@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.storagegateway.kotlin

import com.pulumi.aws.storagegateway.TapePoolArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an AWS Storage Gateway Tape Pool.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.storagegateway.TapePool("example", {
 *     poolName: "example",
 *     storageClass: "GLACIER",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.storagegateway.TapePool("example",
 *     pool_name="example",
 *     storage_class="GLACIER")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.StorageGateway.TapePool("example", new()
 *     {
 *         PoolName = "example",
 *         StorageClass = "GLACIER",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/storagegateway"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storagegateway.NewTapePool(ctx, "example", &storagegateway.TapePoolArgs{
 * 			PoolName:     pulumi.String("example"),
 * 			StorageClass: pulumi.String("GLACIER"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.storagegateway.TapePool;
 * import com.pulumi.aws.storagegateway.TapePoolArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new TapePool("example", TapePoolArgs.builder()
 *             .poolName("example")
 *             .storageClass("GLACIER")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:storagegateway:TapePool
 *     properties:
 *       poolName: example
 *       storageClass: GLACIER
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_storagegateway_tape_pool` using the volume Amazon Resource Name (ARN). For example:
 * ```sh
 * $ pulumi import aws:storagegateway/tapePool:TapePool example arn:aws:storagegateway:us-east-1:123456789012:tapepool/pool-12345678
 * ```
 * @property poolName The name of the new custom tape pool.
 * @property retentionLockTimeInDays Tape retention lock time is set in days. Tape retention lock can be enabled for up to 100 years (36,500 days). Default value is 0.
 * @property retentionLockType Tape retention lock can be configured in two modes. When configured in governance mode, AWS accounts with specific IAM permissions are authorized to remove the tape retention lock from archived virtual tapes. When configured in compliance mode, the tape retention lock cannot be removed by any user, including the root AWS account. Possible values are `COMPLIANCE`, `GOVERNANCE`, and `NONE`. Default value is `NONE`.
 * @property storageClass The storage class that is associated with the new custom pool. When you use your backup application to eject the tape, the tape is archived directly into the storage class that corresponds to the pool. Possible values are `DEEP_ARCHIVE` or `GLACIER`.
 * @property tags Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class TapePoolArgs(
    public val poolName: Output<String>? = null,
    public val retentionLockTimeInDays: Output<Int>? = null,
    public val retentionLockType: Output<String>? = null,
    public val storageClass: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.storagegateway.TapePoolArgs> {
    override fun toJava(): com.pulumi.aws.storagegateway.TapePoolArgs =
        com.pulumi.aws.storagegateway.TapePoolArgs.builder()
            .poolName(poolName?.applyValue({ args0 -> args0 }))
            .retentionLockTimeInDays(retentionLockTimeInDays?.applyValue({ args0 -> args0 }))
            .retentionLockType(retentionLockType?.applyValue({ args0 -> args0 }))
            .storageClass(storageClass?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [TapePoolArgs].
 */
@PulumiTagMarker
public class TapePoolArgsBuilder internal constructor() {
    private var poolName: Output<String>? = null

    private var retentionLockTimeInDays: Output<Int>? = null

    private var retentionLockType: Output<String>? = null

    private var storageClass: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the new custom tape pool.
     */
    @JvmName("bhhmwlaihhvwjicu")
    public suspend fun poolName(`value`: Output<String>) {
        this.poolName = value
    }

    /**
     * @param value Tape retention lock time is set in days. Tape retention lock can be enabled for up to 100 years (36,500 days). Default value is 0.
     */
    @JvmName("clfdnvfwiiqqjtmq")
    public suspend fun retentionLockTimeInDays(`value`: Output<Int>) {
        this.retentionLockTimeInDays = value
    }

    /**
     * @param value Tape retention lock can be configured in two modes. When configured in governance mode, AWS accounts with specific IAM permissions are authorized to remove the tape retention lock from archived virtual tapes. When configured in compliance mode, the tape retention lock cannot be removed by any user, including the root AWS account. Possible values are `COMPLIANCE`, `GOVERNANCE`, and `NONE`. Default value is `NONE`.
     */
    @JvmName("ysingkbluyljskqm")
    public suspend fun retentionLockType(`value`: Output<String>) {
        this.retentionLockType = value
    }

    /**
     * @param value The storage class that is associated with the new custom pool. When you use your backup application to eject the tape, the tape is archived directly into the storage class that corresponds to the pool. Possible values are `DEEP_ARCHIVE` or `GLACIER`.
     */
    @JvmName("faxowwonlxaujyge")
    public suspend fun storageClass(`value`: Output<String>) {
        this.storageClass = value
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("sjqdmmupfcbblwai")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the new custom tape pool.
     */
    @JvmName("gnelktdkgmbtnotc")
    public suspend fun poolName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.poolName = mapped
    }

    /**
     * @param value Tape retention lock time is set in days. Tape retention lock can be enabled for up to 100 years (36,500 days). Default value is 0.
     */
    @JvmName("ymlqrdbfldsxymru")
    public suspend fun retentionLockTimeInDays(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retentionLockTimeInDays = mapped
    }

    /**
     * @param value Tape retention lock can be configured in two modes. When configured in governance mode, AWS accounts with specific IAM permissions are authorized to remove the tape retention lock from archived virtual tapes. When configured in compliance mode, the tape retention lock cannot be removed by any user, including the root AWS account. Possible values are `COMPLIANCE`, `GOVERNANCE`, and `NONE`. Default value is `NONE`.
     */
    @JvmName("apxtywijiceuualw")
    public suspend fun retentionLockType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retentionLockType = mapped
    }

    /**
     * @param value The storage class that is associated with the new custom pool. When you use your backup application to eject the tape, the tape is archived directly into the storage class that corresponds to the pool. Possible values are `DEEP_ARCHIVE` or `GLACIER`.
     */
    @JvmName("iurtoivctmtspbic")
    public suspend fun storageClass(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageClass = mapped
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("fhocpuarnknyvvcb")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("jgwhvpsmjochewxv")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): TapePoolArgs = TapePoolArgs(
        poolName = poolName,
        retentionLockTimeInDays = retentionLockTimeInDays,
        retentionLockType = retentionLockType,
        storageClass = storageClass,
        tags = tags,
    )
}
