@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.storagegateway.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [UploadBuffer].
 */
@PulumiTagMarker
public class UploadBufferResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: UploadBufferArgs = UploadBufferArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend UploadBufferArgsBuilder.() -> Unit) {
        val builder = UploadBufferArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): UploadBuffer {
        val builtJavaResource = com.pulumi.aws.storagegateway.UploadBuffer(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return UploadBuffer(builtJavaResource)
    }
}

/**
 * Manages an AWS Storage Gateway upload buffer.
 * > **NOTE:** The Storage Gateway API provides no method to remove an upload buffer disk. Destroying this resource does not perform any Storage Gateway actions.
 * ## Example Usage
 * ### Cached and VTL Gateway Type
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = aws.storagegateway.getLocalDisk({
 *     diskNode: testAwsVolumeAttachment.deviceName,
 *     gatewayArn: testAwsStoragegatewayGateway.arn,
 * });
 * const testUploadBuffer = new aws.storagegateway.UploadBuffer("test", {
 *     diskPath: test.then(test => test.diskPath),
 *     gatewayArn: testAwsStoragegatewayGateway.arn,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.storagegateway.get_local_disk(disk_node=test_aws_volume_attachment["deviceName"],
 *     gateway_arn=test_aws_storagegateway_gateway["arn"])
 * test_upload_buffer = aws.storagegateway.UploadBuffer("test",
 *     disk_path=test.disk_path,
 *     gateway_arn=test_aws_storagegateway_gateway["arn"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = Aws.StorageGateway.GetLocalDisk.Invoke(new()
 *     {
 *         DiskNode = testAwsVolumeAttachment.DeviceName,
 *         GatewayArn = testAwsStoragegatewayGateway.Arn,
 *     });
 *     var testUploadBuffer = new Aws.StorageGateway.UploadBuffer("test", new()
 *     {
 *         DiskPath = test.Apply(getLocalDiskResult => getLocalDiskResult.DiskPath),
 *         GatewayArn = testAwsStoragegatewayGateway.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/storagegateway"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		test, err := storagegateway.GetLocalDisk(ctx, &storagegateway.GetLocalDiskArgs{
 * 			DiskNode:   pulumi.StringRef(testAwsVolumeAttachment.DeviceName),
 * 			GatewayArn: testAwsStoragegatewayGateway.Arn,
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = storagegateway.NewUploadBuffer(ctx, "test", &storagegateway.UploadBufferArgs{
 * 			DiskPath:   pulumi.String(test.DiskPath),
 * 			GatewayArn: pulumi.Any(testAwsStoragegatewayGateway.Arn),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.storagegateway.StoragegatewayFunctions;
 * import com.pulumi.aws.storagegateway.inputs.GetLocalDiskArgs;
 * import com.pulumi.aws.storagegateway.UploadBuffer;
 * import com.pulumi.aws.storagegateway.UploadBufferArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var test = StoragegatewayFunctions.getLocalDisk(GetLocalDiskArgs.builder()
 *             .diskNode(testAwsVolumeAttachment.deviceName())
 *             .gatewayArn(testAwsStoragegatewayGateway.arn())
 *             .build());
 *         var testUploadBuffer = new UploadBuffer("testUploadBuffer", UploadBufferArgs.builder()
 *             .diskPath(test.applyValue(getLocalDiskResult -> getLocalDiskResult.diskPath()))
 *             .gatewayArn(testAwsStoragegatewayGateway.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   testUploadBuffer:
 *     type: aws:storagegateway:UploadBuffer
 *     name: test
 *     properties:
 *       diskPath: ${test.diskPath}
 *       gatewayArn: ${testAwsStoragegatewayGateway.arn}
 * variables:
 *   test:
 *     fn::invoke:
 *       Function: aws:storagegateway:getLocalDisk
 *       Arguments:
 *         diskNode: ${testAwsVolumeAttachment.deviceName}
 *         gatewayArn: ${testAwsStoragegatewayGateway.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Stored Gateway Type
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = aws.storagegateway.getLocalDisk({
 *     diskNode: testAwsVolumeAttachment.deviceName,
 *     gatewayArn: testAwsStoragegatewayGateway.arn,
 * });
 * const example = new aws.storagegateway.UploadBuffer("example", {
 *     diskId: exampleAwsStoragegatewayLocalDisk.id,
 *     gatewayArn: exampleAwsStoragegatewayGateway.arn,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.storagegateway.get_local_disk(disk_node=test_aws_volume_attachment["deviceName"],
 *     gateway_arn=test_aws_storagegateway_gateway["arn"])
 * example = aws.storagegateway.UploadBuffer("example",
 *     disk_id=example_aws_storagegateway_local_disk["id"],
 *     gateway_arn=example_aws_storagegateway_gateway["arn"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = Aws.StorageGateway.GetLocalDisk.Invoke(new()
 *     {
 *         DiskNode = testAwsVolumeAttachment.DeviceName,
 *         GatewayArn = testAwsStoragegatewayGateway.Arn,
 *     });
 *     var example = new Aws.StorageGateway.UploadBuffer("example", new()
 *     {
 *         DiskId = exampleAwsStoragegatewayLocalDisk.Id,
 *         GatewayArn = exampleAwsStoragegatewayGateway.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/storagegateway"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storagegateway.GetLocalDisk(ctx, &storagegateway.GetLocalDiskArgs{
 * 			DiskNode:   pulumi.StringRef(testAwsVolumeAttachment.DeviceName),
 * 			GatewayArn: testAwsStoragegatewayGateway.Arn,
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = storagegateway.NewUploadBuffer(ctx, "example", &storagegateway.UploadBufferArgs{
 * 			DiskId:     pulumi.Any(exampleAwsStoragegatewayLocalDisk.Id),
 * 			GatewayArn: pulumi.Any(exampleAwsStoragegatewayGateway.Arn),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.storagegateway.StoragegatewayFunctions;
 * import com.pulumi.aws.storagegateway.inputs.GetLocalDiskArgs;
 * import com.pulumi.aws.storagegateway.UploadBuffer;
 * import com.pulumi.aws.storagegateway.UploadBufferArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var test = StoragegatewayFunctions.getLocalDisk(GetLocalDiskArgs.builder()
 *             .diskNode(testAwsVolumeAttachment.deviceName())
 *             .gatewayArn(testAwsStoragegatewayGateway.arn())
 *             .build());
 *         var example = new UploadBuffer("example", UploadBufferArgs.builder()
 *             .diskId(exampleAwsStoragegatewayLocalDisk.id())
 *             .gatewayArn(exampleAwsStoragegatewayGateway.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:storagegateway:UploadBuffer
 *     properties:
 *       diskId: ${exampleAwsStoragegatewayLocalDisk.id}
 *       gatewayArn: ${exampleAwsStoragegatewayGateway.arn}
 * variables:
 *   test:
 *     fn::invoke:
 *       Function: aws:storagegateway:getLocalDisk
 *       Arguments:
 *         diskNode: ${testAwsVolumeAttachment.deviceName}
 *         gatewayArn: ${testAwsStoragegatewayGateway.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_storagegateway_upload_buffer` using the gateway Amazon Resource Name (ARN) and local disk identifier separated with a colon (`:`). For example:
 * ```sh
 * $ pulumi import aws:storagegateway/uploadBuffer:UploadBuffer example arn:aws:storagegateway:us-east-1:123456789012:gateway/sgw-12345678:pci-0000:03:00.0-scsi-0:0:0:0
 * ```
 */
public class UploadBuffer internal constructor(
    override val javaResource: com.pulumi.aws.storagegateway.UploadBuffer,
) : KotlinCustomResource(javaResource, UploadBufferMapper) {
    /**
     * Local disk identifier. For example, `pci-0000:03:00.0-scsi-0:0:0:0`.
     */
    public val diskId: Output<String>
        get() = javaResource.diskId().applyValue({ args0 -> args0 })

    /**
     * Local disk path. For example, `/dev/nvme1n1`.
     */
    public val diskPath: Output<String>
        get() = javaResource.diskPath().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) of the gateway.
     */
    public val gatewayArn: Output<String>
        get() = javaResource.gatewayArn().applyValue({ args0 -> args0 })
}

public object UploadBufferMapper : ResourceMapper<UploadBuffer> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.storagegateway.UploadBuffer::class == javaResource::class

    override fun map(javaResource: Resource): UploadBuffer = UploadBuffer(
        javaResource as
            com.pulumi.aws.storagegateway.UploadBuffer,
    )
}

/**
 * @see [UploadBuffer].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [UploadBuffer].
 */
public suspend fun uploadBuffer(
    name: String,
    block: suspend UploadBufferResourceBuilder.() -> Unit,
): UploadBuffer {
    val builder = UploadBufferResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [UploadBuffer].
 * @param name The _unique_ name of the resulting resource.
 */
public fun uploadBuffer(name: String): UploadBuffer {
    val builder = UploadBufferResourceBuilder()
    builder.name(name)
    return builder.build()
}
