@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.storagegateway.kotlin

import com.pulumi.aws.storagegateway.WorkingStorageArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Manages an AWS Storage Gateway working storage.
 * > **NOTE:** The Storage Gateway API provides no method to remove a working storage disk. Destroying this resource does not perform any Storage Gateway actions.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.storagegateway.WorkingStorage("example", {
 *     diskId: exampleAwsStoragegatewayLocalDisk.id,
 *     gatewayArn: exampleAwsStoragegatewayGateway.arn,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.storagegateway.WorkingStorage("example",
 *     disk_id=example_aws_storagegateway_local_disk["id"],
 *     gateway_arn=example_aws_storagegateway_gateway["arn"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.StorageGateway.WorkingStorage("example", new()
 *     {
 *         DiskId = exampleAwsStoragegatewayLocalDisk.Id,
 *         GatewayArn = exampleAwsStoragegatewayGateway.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/storagegateway"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storagegateway.NewWorkingStorage(ctx, "example", &storagegateway.WorkingStorageArgs{
 * 			DiskId:     pulumi.Any(exampleAwsStoragegatewayLocalDisk.Id),
 * 			GatewayArn: pulumi.Any(exampleAwsStoragegatewayGateway.Arn),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.storagegateway.WorkingStorage;
 * import com.pulumi.aws.storagegateway.WorkingStorageArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new WorkingStorage("example", WorkingStorageArgs.builder()
 *             .diskId(exampleAwsStoragegatewayLocalDisk.id())
 *             .gatewayArn(exampleAwsStoragegatewayGateway.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:storagegateway:WorkingStorage
 *     properties:
 *       diskId: ${exampleAwsStoragegatewayLocalDisk.id}
 *       gatewayArn: ${exampleAwsStoragegatewayGateway.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_storagegateway_working_storage` using the gateway Amazon Resource Name (ARN) and local disk identifier separated with a colon (`:`). For example:
 * ```sh
 * $ pulumi import aws:storagegateway/workingStorage:WorkingStorage example arn:aws:storagegateway:us-east-1:123456789012:gateway/sgw-12345678:pci-0000:03:00.0-scsi-0:0:0:0
 * ```
 * @property diskId Local disk identifier. For example, `pci-0000:03:00.0-scsi-0:0:0:0`.
 * @property gatewayArn The Amazon Resource Name (ARN) of the gateway.
 */
public data class WorkingStorageArgs(
    public val diskId: Output<String>? = null,
    public val gatewayArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.storagegateway.WorkingStorageArgs> {
    override fun toJava(): com.pulumi.aws.storagegateway.WorkingStorageArgs =
        com.pulumi.aws.storagegateway.WorkingStorageArgs.builder()
            .diskId(diskId?.applyValue({ args0 -> args0 }))
            .gatewayArn(gatewayArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkingStorageArgs].
 */
@PulumiTagMarker
public class WorkingStorageArgsBuilder internal constructor() {
    private var diskId: Output<String>? = null

    private var gatewayArn: Output<String>? = null

    /**
     * @param value Local disk identifier. For example, `pci-0000:03:00.0-scsi-0:0:0:0`.
     */
    @JvmName("hwvmagihsufjiqqq")
    public suspend fun diskId(`value`: Output<String>) {
        this.diskId = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the gateway.
     */
    @JvmName("phytuyatjeetmlyb")
    public suspend fun gatewayArn(`value`: Output<String>) {
        this.gatewayArn = value
    }

    /**
     * @param value Local disk identifier. For example, `pci-0000:03:00.0-scsi-0:0:0:0`.
     */
    @JvmName("euevvgnfbsdsxxvq")
    public suspend fun diskId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskId = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the gateway.
     */
    @JvmName("fkmljgjdmxqatjkh")
    public suspend fun gatewayArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gatewayArn = mapped
    }

    internal fun build(): WorkingStorageArgs = WorkingStorageArgs(
        diskId = diskId,
        gatewayArn = gatewayArn,
    )
}
