@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.storagegateway.kotlin.inputs

import com.pulumi.aws.storagegateway.inputs.FileSystemAssociationCacheAttributesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property cacheStaleTimeoutInSeconds Refreshes a file share's cache by using Time To Live (TTL).
 * TTL is the length of time since the last refresh after which access to the directory would cause the file gateway
 * to first refresh that directory's contents from the Amazon S3 bucket. Valid Values: `0` or `300` to `2592000` seconds (5 minutes to 30 days). Defaults to `0`
 */
public data class FileSystemAssociationCacheAttributesArgs(
    public val cacheStaleTimeoutInSeconds: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.storagegateway.inputs.FileSystemAssociationCacheAttributesArgs> {
    override fun toJava(): com.pulumi.aws.storagegateway.inputs.FileSystemAssociationCacheAttributesArgs =
        com.pulumi.aws.storagegateway.inputs.FileSystemAssociationCacheAttributesArgs.builder()
            .cacheStaleTimeoutInSeconds(cacheStaleTimeoutInSeconds?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FileSystemAssociationCacheAttributesArgs].
 */
@PulumiTagMarker
public class FileSystemAssociationCacheAttributesArgsBuilder internal constructor() {
    private var cacheStaleTimeoutInSeconds: Output<Int>? = null

    /**
     * @param value Refreshes a file share's cache by using Time To Live (TTL).
     * TTL is the length of time since the last refresh after which access to the directory would cause the file gateway
     * to first refresh that directory's contents from the Amazon S3 bucket. Valid Values: `0` or `300` to `2592000` seconds (5 minutes to 30 days). Defaults to `0`
     */
    @JvmName("jxepfkppcqxqicmu")
    public suspend fun cacheStaleTimeoutInSeconds(`value`: Output<Int>) {
        this.cacheStaleTimeoutInSeconds = value
    }

    /**
     * @param value Refreshes a file share's cache by using Time To Live (TTL).
     * TTL is the length of time since the last refresh after which access to the directory would cause the file gateway
     * to first refresh that directory's contents from the Amazon S3 bucket. Valid Values: `0` or `300` to `2592000` seconds (5 minutes to 30 days). Defaults to `0`
     */
    @JvmName("rwujqhqmxyxcndle")
    public suspend fun cacheStaleTimeoutInSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cacheStaleTimeoutInSeconds = mapped
    }

    internal fun build(): FileSystemAssociationCacheAttributesArgs =
        FileSystemAssociationCacheAttributesArgs(
            cacheStaleTimeoutInSeconds = cacheStaleTimeoutInSeconds,
        )
}
