@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.storagegateway.kotlin.inputs

import com.pulumi.aws.storagegateway.inputs.GetLocalDiskPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getLocalDisk.
 * @property diskNode Device node of the local disk to retrieve. For example, `/dev/sdb`.
 * @property diskPath Device path of the local disk to retrieve. For example, `/dev/xvdb` or `/dev/nvme1n1`.
 * @property gatewayArn ARN of the gateway.
 */
public data class GetLocalDiskPlainArgs(
    public val diskNode: String? = null,
    public val diskPath: String? = null,
    public val gatewayArn: String,
) : ConvertibleToJava<com.pulumi.aws.storagegateway.inputs.GetLocalDiskPlainArgs> {
    override fun toJava(): com.pulumi.aws.storagegateway.inputs.GetLocalDiskPlainArgs =
        com.pulumi.aws.storagegateway.inputs.GetLocalDiskPlainArgs.builder()
            .diskNode(diskNode?.let({ args0 -> args0 }))
            .diskPath(diskPath?.let({ args0 -> args0 }))
            .gatewayArn(gatewayArn.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetLocalDiskPlainArgs].
 */
@PulumiTagMarker
public class GetLocalDiskPlainArgsBuilder internal constructor() {
    private var diskNode: String? = null

    private var diskPath: String? = null

    private var gatewayArn: String? = null

    /**
     * @param value Device node of the local disk to retrieve. For example, `/dev/sdb`.
     */
    @JvmName("kdbpeaggsbimecdh")
    public suspend fun diskNode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.diskNode = mapped
    }

    /**
     * @param value Device path of the local disk to retrieve. For example, `/dev/xvdb` or `/dev/nvme1n1`.
     */
    @JvmName("jfxwwmhlmiembutc")
    public suspend fun diskPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.diskPath = mapped
    }

    /**
     * @param value ARN of the gateway.
     */
    @JvmName("labmvtmnfsvcfpqi")
    public suspend fun gatewayArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.gatewayArn = mapped
    }

    internal fun build(): GetLocalDiskPlainArgs = GetLocalDiskPlainArgs(
        diskNode = diskNode,
        diskPath = diskPath,
        gatewayArn = gatewayArn ?: throw PulumiNullFieldException("gatewayArn"),
    )
}
