@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.storagegateway.kotlin.inputs

import com.pulumi.aws.storagegateway.inputs.NfsFileShareNfsFileShareDefaultsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property directoryMode The Unix directory mode in the string form "nnnn". Defaults to `"0777"`.
 * @property fileMode The Unix file mode in the string form "nnnn". Defaults to `"0666"`.
 * @property groupId The default group ID for the file share (unless the files have another group ID specified). Defaults to `65534` (`nfsnobody`). Valid values: `0` through `4294967294`.
 * @property ownerId The default owner ID for the file share (unless the files have another owner ID specified). Defaults to `65534` (`nfsnobody`). Valid values: `0` through `4294967294`.
 */
public data class NfsFileShareNfsFileShareDefaultsArgs(
    public val directoryMode: Output<String>? = null,
    public val fileMode: Output<String>? = null,
    public val groupId: Output<String>? = null,
    public val ownerId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.storagegateway.inputs.NfsFileShareNfsFileShareDefaultsArgs> {
    override fun toJava(): com.pulumi.aws.storagegateway.inputs.NfsFileShareNfsFileShareDefaultsArgs =
        com.pulumi.aws.storagegateway.inputs.NfsFileShareNfsFileShareDefaultsArgs.builder()
            .directoryMode(directoryMode?.applyValue({ args0 -> args0 }))
            .fileMode(fileMode?.applyValue({ args0 -> args0 }))
            .groupId(groupId?.applyValue({ args0 -> args0 }))
            .ownerId(ownerId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NfsFileShareNfsFileShareDefaultsArgs].
 */
@PulumiTagMarker
public class NfsFileShareNfsFileShareDefaultsArgsBuilder internal constructor() {
    private var directoryMode: Output<String>? = null

    private var fileMode: Output<String>? = null

    private var groupId: Output<String>? = null

    private var ownerId: Output<String>? = null

    /**
     * @param value The Unix directory mode in the string form "nnnn". Defaults to `"0777"`.
     */
    @JvmName("twxaqnoauhfyoojc")
    public suspend fun directoryMode(`value`: Output<String>) {
        this.directoryMode = value
    }

    /**
     * @param value The Unix file mode in the string form "nnnn". Defaults to `"0666"`.
     */
    @JvmName("mvnqvpritnighykj")
    public suspend fun fileMode(`value`: Output<String>) {
        this.fileMode = value
    }

    /**
     * @param value The default group ID for the file share (unless the files have another group ID specified). Defaults to `65534` (`nfsnobody`). Valid values: `0` through `4294967294`.
     */
    @JvmName("ppvgmsbtdksifgde")
    public suspend fun groupId(`value`: Output<String>) {
        this.groupId = value
    }

    /**
     * @param value The default owner ID for the file share (unless the files have another owner ID specified). Defaults to `65534` (`nfsnobody`). Valid values: `0` through `4294967294`.
     */
    @JvmName("woqtnpixdtjgafwp")
    public suspend fun ownerId(`value`: Output<String>) {
        this.ownerId = value
    }

    /**
     * @param value The Unix directory mode in the string form "nnnn". Defaults to `"0777"`.
     */
    @JvmName("mxxjjhromflxnkks")
    public suspend fun directoryMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.directoryMode = mapped
    }

    /**
     * @param value The Unix file mode in the string form "nnnn". Defaults to `"0666"`.
     */
    @JvmName("fuacunhpmuykbsfb")
    public suspend fun fileMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileMode = mapped
    }

    /**
     * @param value The default group ID for the file share (unless the files have another group ID specified). Defaults to `65534` (`nfsnobody`). Valid values: `0` through `4294967294`.
     */
    @JvmName("wsuvlqabyhxeidny")
    public suspend fun groupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupId = mapped
    }

    /**
     * @param value The default owner ID for the file share (unless the files have another owner ID specified). Defaults to `65534` (`nfsnobody`). Valid values: `0` through `4294967294`.
     */
    @JvmName("thwlwrlyogstdnfr")
    public suspend fun ownerId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ownerId = mapped
    }

    internal fun build(): NfsFileShareNfsFileShareDefaultsArgs = NfsFileShareNfsFileShareDefaultsArgs(
        directoryMode = directoryMode,
        fileMode = fileMode,
        groupId = groupId,
        ownerId = ownerId,
    )
}
