@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.storagegateway.kotlin.inputs

import com.pulumi.aws.storagegateway.inputs.SmbFileShareCacheAttributesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property cacheStaleTimeoutInSeconds Refreshes a file share's cache by using Time To Live (TTL).
 * TTL is the length of time since the last refresh after which access to the directory would cause the file gateway
 * to first refresh that directory's contents from the Amazon S3 bucket. Valid Values: 300 to 2,592,000 seconds (5 minutes to 30 days)
 */
public data class SmbFileShareCacheAttributesArgs(
    public val cacheStaleTimeoutInSeconds: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.storagegateway.inputs.SmbFileShareCacheAttributesArgs> {
    override fun toJava(): com.pulumi.aws.storagegateway.inputs.SmbFileShareCacheAttributesArgs =
        com.pulumi.aws.storagegateway.inputs.SmbFileShareCacheAttributesArgs.builder()
            .cacheStaleTimeoutInSeconds(cacheStaleTimeoutInSeconds?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SmbFileShareCacheAttributesArgs].
 */
@PulumiTagMarker
public class SmbFileShareCacheAttributesArgsBuilder internal constructor() {
    private var cacheStaleTimeoutInSeconds: Output<Int>? = null

    /**
     * @param value Refreshes a file share's cache by using Time To Live (TTL).
     * TTL is the length of time since the last refresh after which access to the directory would cause the file gateway
     * to first refresh that directory's contents from the Amazon S3 bucket. Valid Values: 300 to 2,592,000 seconds (5 minutes to 30 days)
     */
    @JvmName("gdftpclnesmcwsmo")
    public suspend fun cacheStaleTimeoutInSeconds(`value`: Output<Int>) {
        this.cacheStaleTimeoutInSeconds = value
    }

    /**
     * @param value Refreshes a file share's cache by using Time To Live (TTL).
     * TTL is the length of time since the last refresh after which access to the directory would cause the file gateway
     * to first refresh that directory's contents from the Amazon S3 bucket. Valid Values: 300 to 2,592,000 seconds (5 minutes to 30 days)
     */
    @JvmName("kdgdnrdoqdfjfoss")
    public suspend fun cacheStaleTimeoutInSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cacheStaleTimeoutInSeconds = mapped
    }

    internal fun build(): SmbFileShareCacheAttributesArgs = SmbFileShareCacheAttributesArgs(
        cacheStaleTimeoutInSeconds = cacheStaleTimeoutInSeconds,
    )
}
