@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.storagegateway.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property cacheStaleTimeoutInSeconds Refreshes a file share's cache by using Time To Live (TTL).
 * TTL is the length of time since the last refresh after which access to the directory would cause the file gateway
 * to first refresh that directory's contents from the Amazon S3 bucket. Valid Values: `0` or `300` to `2592000` seconds (5 minutes to 30 days). Defaults to `0`
 */
public data class FileSystemAssociationCacheAttributes(
    public val cacheStaleTimeoutInSeconds: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.storagegateway.outputs.FileSystemAssociationCacheAttributes): FileSystemAssociationCacheAttributes = FileSystemAssociationCacheAttributes(
            cacheStaleTimeoutInSeconds = javaType.cacheStaleTimeoutInSeconds().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
