@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.storagegateway.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property activeDirectoryStatus
 * @property domainControllers List of IPv4 addresses, NetBIOS names, or host names of your domain server.
 * If you need to specify the port number include it after the colon (“:”). For example, `mydc.mydomain.com:389`.
 * @property domainName The name of the domain that you want the gateway to join.
 * @property organizationalUnit The organizational unit (OU) is a container in an Active Directory that can hold users, groups,
 * computers, and other OUs and this parameter specifies the OU that the gateway will join within the AD domain.
 * @property password The password of the user who has permission to add the gateway to the Active Directory domain.
 * @property timeoutInSeconds Specifies the time in seconds, in which the JoinDomain operation must complete. The default is `20` seconds.
 * @property username The user name of user who has permission to add the gateway to the Active Directory domain.
 */
public data class GatewaySmbActiveDirectorySettings(
    public val activeDirectoryStatus: String? = null,
    public val domainControllers: List<String>? = null,
    public val domainName: String,
    public val organizationalUnit: String? = null,
    public val password: String,
    public val timeoutInSeconds: Int? = null,
    public val username: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.storagegateway.outputs.GatewaySmbActiveDirectorySettings): GatewaySmbActiveDirectorySettings = GatewaySmbActiveDirectorySettings(
            activeDirectoryStatus = javaType.activeDirectoryStatus().map({ args0 -> args0 }).orElse(null),
            domainControllers = javaType.domainControllers().map({ args0 -> args0 }),
            domainName = javaType.domainName(),
            organizationalUnit = javaType.organizationalUnit().map({ args0 -> args0 }).orElse(null),
            password = javaType.password(),
            timeoutInSeconds = javaType.timeoutInSeconds().map({ args0 -> args0 }).orElse(null),
            username = javaType.username(),
        )
    }
}
