@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.storagegateway.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property directoryMode The Unix directory mode in the string form "nnnn". Defaults to `"0777"`.
 * @property fileMode The Unix file mode in the string form "nnnn". Defaults to `"0666"`.
 * @property groupId The default group ID for the file share (unless the files have another group ID specified). Defaults to `65534` (`nfsnobody`). Valid values: `0` through `4294967294`.
 * @property ownerId The default owner ID for the file share (unless the files have another owner ID specified). Defaults to `65534` (`nfsnobody`). Valid values: `0` through `4294967294`.
 */
public data class NfsFileShareNfsFileShareDefaults(
    public val directoryMode: String? = null,
    public val fileMode: String? = null,
    public val groupId: String? = null,
    public val ownerId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.storagegateway.outputs.NfsFileShareNfsFileShareDefaults): NfsFileShareNfsFileShareDefaults = NfsFileShareNfsFileShareDefaults(
            directoryMode = javaType.directoryMode().map({ args0 -> args0 }).orElse(null),
            fileMode = javaType.fileMode().map({ args0 -> args0 }).orElse(null),
            groupId = javaType.groupId().map({ args0 -> args0 }).orElse(null),
            ownerId = javaType.ownerId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
