@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.synthetics.kotlin

import com.pulumi.aws.synthetics.GroupAssociationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Synthetics Group Association resource.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.synthetics.GroupAssociation("example", {
 *     groupName: exampleAwsSyntheticsGroup.name,
 *     canaryArn: exampleAwsSyntheticsCanary.arn,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.synthetics.GroupAssociation("example",
 *     group_name=example_aws_synthetics_group["name"],
 *     canary_arn=example_aws_synthetics_canary["arn"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Synthetics.GroupAssociation("example", new()
 *     {
 *         GroupName = exampleAwsSyntheticsGroup.Name,
 *         CanaryArn = exampleAwsSyntheticsCanary.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/synthetics"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := synthetics.NewGroupAssociation(ctx, "example", &synthetics.GroupAssociationArgs{
 * 			GroupName: pulumi.Any(exampleAwsSyntheticsGroup.Name),
 * 			CanaryArn: pulumi.Any(exampleAwsSyntheticsCanary.Arn),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.synthetics.GroupAssociation;
 * import com.pulumi.aws.synthetics.GroupAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new GroupAssociation("example", GroupAssociationArgs.builder()
 *             .groupName(exampleAwsSyntheticsGroup.name())
 *             .canaryArn(exampleAwsSyntheticsCanary.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:synthetics:GroupAssociation
 *     properties:
 *       groupName: ${exampleAwsSyntheticsGroup.name}
 *       canaryArn: ${exampleAwsSyntheticsCanary.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import CloudWatch Synthetics Group Association using the `canary_arn,group_name`. For example:
 * ```sh
 * $ pulumi import aws:synthetics/groupAssociation:GroupAssociation example arn:aws:synthetics:us-west-2:123456789012:canary:tf-acc-test-abcd1234,examplename
 * ```
 * @property canaryArn ARN of the canary.
 * @property groupName Name of the group that the canary will be associated with.
 */
public data class GroupAssociationArgs(
    public val canaryArn: Output<String>? = null,
    public val groupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.synthetics.GroupAssociationArgs> {
    override fun toJava(): com.pulumi.aws.synthetics.GroupAssociationArgs =
        com.pulumi.aws.synthetics.GroupAssociationArgs.builder()
            .canaryArn(canaryArn?.applyValue({ args0 -> args0 }))
            .groupName(groupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GroupAssociationArgs].
 */
@PulumiTagMarker
public class GroupAssociationArgsBuilder internal constructor() {
    private var canaryArn: Output<String>? = null

    private var groupName: Output<String>? = null

    /**
     * @param value ARN of the canary.
     */
    @JvmName("edmjfgqmvekwbosv")
    public suspend fun canaryArn(`value`: Output<String>) {
        this.canaryArn = value
    }

    /**
     * @param value Name of the group that the canary will be associated with.
     */
    @JvmName("ulqkygbcgjnqlsqc")
    public suspend fun groupName(`value`: Output<String>) {
        this.groupName = value
    }

    /**
     * @param value ARN of the canary.
     */
    @JvmName("arjtkokdxjnucapy")
    public suspend fun canaryArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.canaryArn = mapped
    }

    /**
     * @param value Name of the group that the canary will be associated with.
     */
    @JvmName("fwbumkshxicrkxkg")
    public suspend fun groupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupName = mapped
    }

    internal fun build(): GroupAssociationArgs = GroupAssociationArgs(
        canaryArn = canaryArn,
        groupName = groupName,
    )
}
