@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.synthetics.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property encryptionMode The encryption method to use for artifacts created by this canary. Valid values are: `SSE_S3` and `SSE_KMS`.
 * @property kmsKeyArn The ARN of the customer-managed KMS key to use, if you specify `SSE_KMS` for `encryption_mode`.
 */
public data class CanaryArtifactConfigS3Encryption(
    public val encryptionMode: String? = null,
    public val kmsKeyArn: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.synthetics.outputs.CanaryArtifactConfigS3Encryption): CanaryArtifactConfigS3Encryption = CanaryArtifactConfigS3Encryption(
            encryptionMode = javaType.encryptionMode().map({ args0 -> args0 }).orElse(null),
            kmsKeyArn = javaType.kmsKeyArn().map({ args0 -> args0 }).orElse(null),
        )
    }
}
