@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.synthetics.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property durationInSeconds Duration in seconds, for the canary to continue making regular runs according to the schedule in the Expression value.
 * @property expression Rate expression or cron expression that defines how often the canary is to run. For rate expression, the syntax is `rate(number unit)`. _unit_ can be `minute`, `minutes`, or `hour`. For cron expression, the syntax is `cron(expression)`. For more information about the syntax for cron expressions, see [Scheduling canary runs using cron](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_cron.html).
 */
public data class CanarySchedule(
    public val durationInSeconds: Int? = null,
    public val expression: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.synthetics.outputs.CanarySchedule): CanarySchedule = CanarySchedule(
            durationInSeconds = javaType.durationInSeconds().map({ args0 -> args0 }).orElse(null),
            expression = javaType.expression(),
        )
    }
}
