@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.synthetics.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property created Date and time the canary was created.
 * @property lastModified Date and time the canary was most recently modified.
 * @property lastStarted Date and time that the canary's most recent run started.
 * @property lastStopped Date and time that the canary's most recent run ended.
 */
public data class CanaryTimeline(
    public val created: String? = null,
    public val lastModified: String? = null,
    public val lastStarted: String? = null,
    public val lastStopped: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.synthetics.outputs.CanaryTimeline): CanaryTimeline = CanaryTimeline(
            created = javaType.created().map({ args0 -> args0 }).orElse(null),
            lastModified = javaType.lastModified().map({ args0 -> args0 }).orElse(null),
            lastStarted = javaType.lastStarted().map({ args0 -> args0 }).orElse(null),
            lastStopped = javaType.lastStopped().map({ args0 -> args0 }).orElse(null),
        )
    }
}
