@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.timestreaminfluxdb.kotlin.inputs

import com.pulumi.aws.timestreaminfluxdb.inputs.DbInstanceLogDeliveryConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property s3Configuration Configuration for S3 bucket log delivery.
 */
public data class DbInstanceLogDeliveryConfigurationArgs(
    public val s3Configuration: Output<DbInstanceLogDeliveryConfigurationS3ConfigurationArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.timestreaminfluxdb.inputs.DbInstanceLogDeliveryConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.timestreaminfluxdb.inputs.DbInstanceLogDeliveryConfigurationArgs =
        com.pulumi.aws.timestreaminfluxdb.inputs.DbInstanceLogDeliveryConfigurationArgs.builder()
            .s3Configuration(
                s3Configuration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [DbInstanceLogDeliveryConfigurationArgs].
 */
@PulumiTagMarker
public class DbInstanceLogDeliveryConfigurationArgsBuilder internal constructor() {
    private var s3Configuration: Output<DbInstanceLogDeliveryConfigurationS3ConfigurationArgs>? = null

    /**
     * @param value Configuration for S3 bucket log delivery.
     */
    @JvmName("amndhdtercnconjp")
    public suspend fun s3Configuration(`value`: Output<DbInstanceLogDeliveryConfigurationS3ConfigurationArgs>) {
        this.s3Configuration = value
    }

    /**
     * @param value Configuration for S3 bucket log delivery.
     */
    @JvmName("huphtlucqgpmfljt")
    public suspend fun s3Configuration(`value`: DbInstanceLogDeliveryConfigurationS3ConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3Configuration = mapped
    }

    /**
     * @param argument Configuration for S3 bucket log delivery.
     */
    @JvmName("uwwfhjqedqrmapaw")
    public suspend fun s3Configuration(argument: suspend DbInstanceLogDeliveryConfigurationS3ConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = DbInstanceLogDeliveryConfigurationS3ConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.s3Configuration = mapped
    }

    internal fun build(): DbInstanceLogDeliveryConfigurationArgs =
        DbInstanceLogDeliveryConfigurationArgs(
            s3Configuration = s3Configuration,
        )
}
