@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.timestreaminfluxdb.kotlin.inputs

import com.pulumi.aws.timestreaminfluxdb.inputs.DbInstanceLogDeliveryConfigurationS3ConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property bucketName Name of the S3 bucket to deliver logs to.
 * @property enabled Indicates whether log delivery to the S3 bucket is enabled.
 * **Note**: Only three arguments do updates in-place: `db_parameter_group_identifier`, `log_delivery_configuration`, and `tags`. Changes to any other argument after a DB instance has been deployed will cause destruction and re-creation of the DB instance. Additionally, when `db_parameter_group_identifier` is added to a DB instance or modified, the DB instance will be updated in-place but if `db_parameter_group_identifier` is removed from a DB instance, the DB instance will be destroyed and re-created.
 */
public data class DbInstanceLogDeliveryConfigurationS3ConfigurationArgs(
    public val bucketName: Output<String>,
    public val enabled: Output<Boolean>,
) :
    ConvertibleToJava<com.pulumi.aws.timestreaminfluxdb.inputs.DbInstanceLogDeliveryConfigurationS3ConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.timestreaminfluxdb.inputs.DbInstanceLogDeliveryConfigurationS3ConfigurationArgs =
        com.pulumi.aws.timestreaminfluxdb.inputs.DbInstanceLogDeliveryConfigurationS3ConfigurationArgs.builder()
            .bucketName(bucketName.applyValue({ args0 -> args0 }))
            .enabled(enabled.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DbInstanceLogDeliveryConfigurationS3ConfigurationArgs].
 */
@PulumiTagMarker
public class DbInstanceLogDeliveryConfigurationS3ConfigurationArgsBuilder internal constructor() {
    private var bucketName: Output<String>? = null

    private var enabled: Output<Boolean>? = null

    /**
     * @param value Name of the S3 bucket to deliver logs to.
     */
    @JvmName("xjrffxwlufcnssif")
    public suspend fun bucketName(`value`: Output<String>) {
        this.bucketName = value
    }

    /**
     * @param value Indicates whether log delivery to the S3 bucket is enabled.
     * **Note**: Only three arguments do updates in-place: `db_parameter_group_identifier`, `log_delivery_configuration`, and `tags`. Changes to any other argument after a DB instance has been deployed will cause destruction and re-creation of the DB instance. Additionally, when `db_parameter_group_identifier` is added to a DB instance or modified, the DB instance will be updated in-place but if `db_parameter_group_identifier` is removed from a DB instance, the DB instance will be destroyed and re-created.
     */
    @JvmName("leupwsnskiwismqd")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Name of the S3 bucket to deliver logs to.
     */
    @JvmName("epwmiakgvplxflxx")
    public suspend fun bucketName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bucketName = mapped
    }

    /**
     * @param value Indicates whether log delivery to the S3 bucket is enabled.
     * **Note**: Only three arguments do updates in-place: `db_parameter_group_identifier`, `log_delivery_configuration`, and `tags`. Changes to any other argument after a DB instance has been deployed will cause destruction and re-creation of the DB instance. Additionally, when `db_parameter_group_identifier` is added to a DB instance or modified, the DB instance will be updated in-place but if `db_parameter_group_identifier` is removed from a DB instance, the DB instance will be destroyed and re-created.
     */
    @JvmName("koyenwuwukpqqcau")
    public suspend fun enabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    internal fun build(): DbInstanceLogDeliveryConfigurationS3ConfigurationArgs =
        DbInstanceLogDeliveryConfigurationS3ConfigurationArgs(
            bucketName = bucketName ?: throw PulumiNullFieldException("bucketName"),
            enabled = enabled ?: throw PulumiNullFieldException("enabled"),
        )
}
