@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.timestreaminfluxdb.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property bucketName Name of the S3 bucket to deliver logs to.
 * @property enabled Indicates whether log delivery to the S3 bucket is enabled.
 * **Note**: Only three arguments do updates in-place: `db_parameter_group_identifier`, `log_delivery_configuration`, and `tags`. Changes to any other argument after a DB instance has been deployed will cause destruction and re-creation of the DB instance. Additionally, when `db_parameter_group_identifier` is added to a DB instance or modified, the DB instance will be updated in-place but if `db_parameter_group_identifier` is removed from a DB instance, the DB instance will be destroyed and re-created.
 */
public data class DbInstanceLogDeliveryConfigurationS3Configuration(
    public val bucketName: String,
    public val enabled: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.timestreaminfluxdb.outputs.DbInstanceLogDeliveryConfigurationS3Configuration): DbInstanceLogDeliveryConfigurationS3Configuration =
            DbInstanceLogDeliveryConfigurationS3Configuration(
                bucketName = javaType.bucketName(),
                enabled = javaType.enabled(),
            )
    }
}
