@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.timestreamwrite.kotlin

import com.pulumi.aws.timestreamwrite.TableArgs.builder
import com.pulumi.aws.timestreamwrite.kotlin.inputs.TableMagneticStoreWritePropertiesArgs
import com.pulumi.aws.timestreamwrite.kotlin.inputs.TableMagneticStoreWritePropertiesArgsBuilder
import com.pulumi.aws.timestreamwrite.kotlin.inputs.TableRetentionPropertiesArgs
import com.pulumi.aws.timestreamwrite.kotlin.inputs.TableRetentionPropertiesArgsBuilder
import com.pulumi.aws.timestreamwrite.kotlin.inputs.TableSchemaArgs
import com.pulumi.aws.timestreamwrite.kotlin.inputs.TableSchemaArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Timestream table resource.
 * ## Example Usage
 * ### Basic usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.timestreamwrite.Table("example", {
 *     databaseName: exampleAwsTimestreamwriteDatabase.databaseName,
 *     tableName: "example",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.timestreamwrite.Table("example",
 *     database_name=example_aws_timestreamwrite_database["databaseName"],
 *     table_name="example")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.TimestreamWrite.Table("example", new()
 *     {
 *         DatabaseName = exampleAwsTimestreamwriteDatabase.DatabaseName,
 *         TableName = "example",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/timestreamwrite"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := timestreamwrite.NewTable(ctx, "example", &timestreamwrite.TableArgs{
 * 			DatabaseName: pulumi.Any(exampleAwsTimestreamwriteDatabase.DatabaseName),
 * 			TableName:    pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.timestreamwrite.Table;
 * import com.pulumi.aws.timestreamwrite.TableArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Table("example", TableArgs.builder()
 *             .databaseName(exampleAwsTimestreamwriteDatabase.databaseName())
 *             .tableName("example")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:timestreamwrite:Table
 *     properties:
 *       databaseName: ${exampleAwsTimestreamwriteDatabase.databaseName}
 *       tableName: example
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Full usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.timestreamwrite.Table("example", {
 *     databaseName: exampleAwsTimestreamwriteDatabase.databaseName,
 *     tableName: "example",
 *     retentionProperties: {
 *         magneticStoreRetentionPeriodInDays: 30,
 *         memoryStoreRetentionPeriodInHours: 8,
 *     },
 *     tags: {
 *         Name: "example-timestream-table",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.timestreamwrite.Table("example",
 *     database_name=example_aws_timestreamwrite_database["databaseName"],
 *     table_name="example",
 *     retention_properties={
 *         "magnetic_store_retention_period_in_days": 30,
 *         "memory_store_retention_period_in_hours": 8,
 *     },
 *     tags={
 *         "Name": "example-timestream-table",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.TimestreamWrite.Table("example", new()
 *     {
 *         DatabaseName = exampleAwsTimestreamwriteDatabase.DatabaseName,
 *         TableName = "example",
 *         RetentionProperties = new Aws.TimestreamWrite.Inputs.TableRetentionPropertiesArgs
 *         {
 *             MagneticStoreRetentionPeriodInDays = 30,
 *             MemoryStoreRetentionPeriodInHours = 8,
 *         },
 *         Tags =
 *         {
 *             { "Name", "example-timestream-table" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/timestreamwrite"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := timestreamwrite.NewTable(ctx, "example", &timestreamwrite.TableArgs{
 * 			DatabaseName: pulumi.Any(exampleAwsTimestreamwriteDatabase.DatabaseName),
 * 			TableName:    pulumi.String("example"),
 * 			RetentionProperties: &timestreamwrite.TableRetentionPropertiesArgs{
 * 				MagneticStoreRetentionPeriodInDays: pulumi.Int(30),
 * 				MemoryStoreRetentionPeriodInHours:  pulumi.Int(8),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("example-timestream-table"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.timestreamwrite.Table;
 * import com.pulumi.aws.timestreamwrite.TableArgs;
 * import com.pulumi.aws.timestreamwrite.inputs.TableRetentionPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Table("example", TableArgs.builder()
 *             .databaseName(exampleAwsTimestreamwriteDatabase.databaseName())
 *             .tableName("example")
 *             .retentionProperties(TableRetentionPropertiesArgs.builder()
 *                 .magneticStoreRetentionPeriodInDays(30)
 *                 .memoryStoreRetentionPeriodInHours(8)
 *                 .build())
 *             .tags(Map.of("Name", "example-timestream-table"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:timestreamwrite:Table
 *     properties:
 *       databaseName: ${exampleAwsTimestreamwriteDatabase.databaseName}
 *       tableName: example
 *       retentionProperties:
 *         magneticStoreRetentionPeriodInDays: 30
 *         memoryStoreRetentionPeriodInHours: 8
 *       tags:
 *         Name: example-timestream-table
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Customer-defined Partition Key
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.timestreamwrite.Table("example", {
 *     databaseName: exampleAwsTimestreamwriteDatabase.databaseName,
 *     tableName: "example",
 *     schema: {
 *         compositePartitionKey: {
 *             enforcementInRecord: "REQUIRED",
 *             name: "attr1",
 *             type: "DIMENSION",
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.timestreamwrite.Table("example",
 *     database_name=example_aws_timestreamwrite_database["databaseName"],
 *     table_name="example",
 *     schema={
 *         "composite_partition_key": {
 *             "enforcement_in_record": "REQUIRED",
 *             "name": "attr1",
 *             "type": "DIMENSION",
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.TimestreamWrite.Table("example", new()
 *     {
 *         DatabaseName = exampleAwsTimestreamwriteDatabase.DatabaseName,
 *         TableName = "example",
 *         Schema = new Aws.TimestreamWrite.Inputs.TableSchemaArgs
 *         {
 *             CompositePartitionKey = new Aws.TimestreamWrite.Inputs.TableSchemaCompositePartitionKeyArgs
 *             {
 *                 EnforcementInRecord = "REQUIRED",
 *                 Name = "attr1",
 *                 Type = "DIMENSION",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/timestreamwrite"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := timestreamwrite.NewTable(ctx, "example", &timestreamwrite.TableArgs{
 * 			DatabaseName: pulumi.Any(exampleAwsTimestreamwriteDatabase.DatabaseName),
 * 			TableName:    pulumi.String("example"),
 * 			Schema: &timestreamwrite.TableSchemaArgs{
 * 				CompositePartitionKey: &timestreamwrite.TableSchemaCompositePartitionKeyArgs{
 * 					EnforcementInRecord: pulumi.String("REQUIRED"),
 * 					Name:                pulumi.String("attr1"),
 * 					Type:                pulumi.String("DIMENSION"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.timestreamwrite.Table;
 * import com.pulumi.aws.timestreamwrite.TableArgs;
 * import com.pulumi.aws.timestreamwrite.inputs.TableSchemaArgs;
 * import com.pulumi.aws.timestreamwrite.inputs.TableSchemaCompositePartitionKeyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Table("example", TableArgs.builder()
 *             .databaseName(exampleAwsTimestreamwriteDatabase.databaseName())
 *             .tableName("example")
 *             .schema(TableSchemaArgs.builder()
 *                 .compositePartitionKey(TableSchemaCompositePartitionKeyArgs.builder()
 *                     .enforcementInRecord("REQUIRED")
 *                     .name("attr1")
 *                     .type("DIMENSION")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:timestreamwrite:Table
 *     properties:
 *       databaseName: ${exampleAwsTimestreamwriteDatabase.databaseName}
 *       tableName: example
 *       schema:
 *         compositePartitionKey:
 *           enforcementInRecord: REQUIRED
 *           name: attr1
 *           type: DIMENSION
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Timestream tables using the `table_name` and `database_name` separate by a colon (`:`). For example:
 * ```sh
 * $ pulumi import aws:timestreamwrite/table:Table example ExampleTable:ExampleDatabase
 * ```
 * @property databaseName The name of the Timestream database.
 * @property magneticStoreWriteProperties Contains properties to set on the table when enabling magnetic store writes. See Magnetic Store Write Properties below for more details.
 * @property retentionProperties The retention duration for the memory store and magnetic store. See Retention Properties below for more details. If not provided, `magnetic_store_retention_period_in_days` default to 73000 and `memory_store_retention_period_in_hours` defaults to 6.
 * @property schema The schema of the table. See Schema below for more details.
 * @property tableName The name of the Timestream table.
 * @property tags Map of tags to assign to this resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class TableArgs(
    public val databaseName: Output<String>? = null,
    public val magneticStoreWriteProperties: Output<TableMagneticStoreWritePropertiesArgs>? = null,
    public val retentionProperties: Output<TableRetentionPropertiesArgs>? = null,
    public val schema: Output<TableSchemaArgs>? = null,
    public val tableName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.timestreamwrite.TableArgs> {
    override fun toJava(): com.pulumi.aws.timestreamwrite.TableArgs =
        com.pulumi.aws.timestreamwrite.TableArgs.builder()
            .databaseName(databaseName?.applyValue({ args0 -> args0 }))
            .magneticStoreWriteProperties(
                magneticStoreWriteProperties?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .retentionProperties(
                retentionProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .schema(schema?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tableName(tableName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [TableArgs].
 */
@PulumiTagMarker
public class TableArgsBuilder internal constructor() {
    private var databaseName: Output<String>? = null

    private var magneticStoreWriteProperties: Output<TableMagneticStoreWritePropertiesArgs>? = null

    private var retentionProperties: Output<TableRetentionPropertiesArgs>? = null

    private var schema: Output<TableSchemaArgs>? = null

    private var tableName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the Timestream database.
     */
    @JvmName("ldmfvrepugqubvol")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value Contains properties to set on the table when enabling magnetic store writes. See Magnetic Store Write Properties below for more details.
     */
    @JvmName("qvhmpvjgmsglktee")
    public suspend fun magneticStoreWriteProperties(`value`: Output<TableMagneticStoreWritePropertiesArgs>) {
        this.magneticStoreWriteProperties = value
    }

    /**
     * @param value The retention duration for the memory store and magnetic store. See Retention Properties below for more details. If not provided, `magnetic_store_retention_period_in_days` default to 73000 and `memory_store_retention_period_in_hours` defaults to 6.
     */
    @JvmName("jmnufemhxbclmtug")
    public suspend fun retentionProperties(`value`: Output<TableRetentionPropertiesArgs>) {
        this.retentionProperties = value
    }

    /**
     * @param value The schema of the table. See Schema below for more details.
     */
    @JvmName("yvvmsdibilgsckvg")
    public suspend fun schema(`value`: Output<TableSchemaArgs>) {
        this.schema = value
    }

    /**
     * @param value The name of the Timestream table.
     */
    @JvmName("gwhcvkxihvpsbskd")
    public suspend fun tableName(`value`: Output<String>) {
        this.tableName = value
    }

    /**
     * @param value Map of tags to assign to this resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("fthqtwuajduoiccd")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the Timestream database.
     */
    @JvmName("pofoepxupwhlasvm")
    public suspend fun databaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value Contains properties to set on the table when enabling magnetic store writes. See Magnetic Store Write Properties below for more details.
     */
    @JvmName("madasaistblkpvim")
    public suspend fun magneticStoreWriteProperties(`value`: TableMagneticStoreWritePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.magneticStoreWriteProperties = mapped
    }

    /**
     * @param argument Contains properties to set on the table when enabling magnetic store writes. See Magnetic Store Write Properties below for more details.
     */
    @JvmName("wcbkiqfcgerogojc")
    public suspend fun magneticStoreWriteProperties(argument: suspend TableMagneticStoreWritePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = TableMagneticStoreWritePropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.magneticStoreWriteProperties = mapped
    }

    /**
     * @param value The retention duration for the memory store and magnetic store. See Retention Properties below for more details. If not provided, `magnetic_store_retention_period_in_days` default to 73000 and `memory_store_retention_period_in_hours` defaults to 6.
     */
    @JvmName("mdsxbtjuvdnaiekr")
    public suspend fun retentionProperties(`value`: TableRetentionPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retentionProperties = mapped
    }

    /**
     * @param argument The retention duration for the memory store and magnetic store. See Retention Properties below for more details. If not provided, `magnetic_store_retention_period_in_days` default to 73000 and `memory_store_retention_period_in_hours` defaults to 6.
     */
    @JvmName("txokhdkositimjqg")
    public suspend fun retentionProperties(argument: suspend TableRetentionPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = TableRetentionPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.retentionProperties = mapped
    }

    /**
     * @param value The schema of the table. See Schema below for more details.
     */
    @JvmName("pfannffvguihiueu")
    public suspend fun schema(`value`: TableSchemaArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schema = mapped
    }

    /**
     * @param argument The schema of the table. See Schema below for more details.
     */
    @JvmName("lucbgpgcoewgbsdb")
    public suspend fun schema(argument: suspend TableSchemaArgsBuilder.() -> Unit) {
        val toBeMapped = TableSchemaArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.schema = mapped
    }

    /**
     * @param value The name of the Timestream table.
     */
    @JvmName("qmmmueqtmrixuncp")
    public suspend fun tableName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tableName = mapped
    }

    /**
     * @param value Map of tags to assign to this resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("gleqxmyebsxkfpik")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to this resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("poessmfkwayxwnyx")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): TableArgs = TableArgs(
        databaseName = databaseName,
        magneticStoreWriteProperties = magneticStoreWriteProperties,
        retentionProperties = retentionProperties,
        schema = schema,
        tableName = tableName,
        tags = tags,
    )
}
