@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.timestreamwrite.kotlin

import com.pulumi.aws.timestreamwrite.TimestreamwriteFunctions.getDatabasePlain
import com.pulumi.aws.timestreamwrite.TimestreamwriteFunctions.getTablePlain
import com.pulumi.aws.timestreamwrite.kotlin.inputs.GetDatabasePlainArgs
import com.pulumi.aws.timestreamwrite.kotlin.inputs.GetDatabasePlainArgsBuilder
import com.pulumi.aws.timestreamwrite.kotlin.inputs.GetTablePlainArgs
import com.pulumi.aws.timestreamwrite.kotlin.inputs.GetTablePlainArgsBuilder
import com.pulumi.aws.timestreamwrite.kotlin.outputs.GetDatabaseResult
import com.pulumi.aws.timestreamwrite.kotlin.outputs.GetTableResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.aws.timestreamwrite.kotlin.outputs.GetDatabaseResult.Companion.toKotlin as getDatabaseResultToKotlin
import com.pulumi.aws.timestreamwrite.kotlin.outputs.GetTableResult.Companion.toKotlin as getTableResultToKotlin

public object TimestreamwriteFunctions {
    /**
     * Data source for managing an AWS Timestream Write Database.
     * ## Example Usage
     * ### Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const test = aws.timestreamwrite.getDatabase({
     *     name: "database-example",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * test = aws.timestreamwrite.get_database(name="database-example")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var test = Aws.TimestreamWrite.GetDatabase.Invoke(new()
     *     {
     *         Name = "database-example",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/timestreamwrite"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := timestreamwrite.LookupDatabase(ctx, &timestreamwrite.LookupDatabaseArgs{
     * 			Name: "database-example",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.timestreamwrite.TimestreamwriteFunctions;
     * import com.pulumi.aws.timestreamwrite.inputs.GetDatabaseArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = TimestreamwriteFunctions.getDatabase(GetDatabaseArgs.builder()
     *             .name("database-example")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   test:
     *     fn::invoke:
     *       Function: aws:timestreamwrite:getDatabase
     *       Arguments:
     *         name: database-example
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getDatabase.
     * @return A collection of values returned by getDatabase.
     */
    public suspend fun getDatabase(argument: GetDatabasePlainArgs): GetDatabaseResult =
        getDatabaseResultToKotlin(getDatabasePlain(argument.toJava()).await())

    /**
     * @see [getDatabase].
     * @param name
     * @return A collection of values returned by getDatabase.
     */
    public suspend fun getDatabase(name: String): GetDatabaseResult {
        val argument = GetDatabasePlainArgs(
            name = name,
        )
        return getDatabaseResultToKotlin(getDatabasePlain(argument.toJava()).await())
    }

    /**
     * @see [getDatabase].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;timestreamwrite&#46;kotlin&#46;inputs&#46;GetDatabasePlainArgs].
     * @return A collection of values returned by getDatabase.
     */
    public suspend fun getDatabase(argument: suspend GetDatabasePlainArgsBuilder.() -> Unit): GetDatabaseResult {
        val builder = GetDatabasePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDatabaseResultToKotlin(getDatabasePlain(builtArgument.toJava()).await())
    }

    /**
     * Data source for managing an AWS Timestream Write Table.
     * ## Example Usage
     * ### Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const test = aws.timestreamwrite.getTable({
     *     databaseName: testAwsTimestreamwriteDatabase.databaseName,
     *     name: testAwsTimestreamwriteTable.tableName,
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * test = aws.timestreamwrite.get_table(database_name=test_aws_timestreamwrite_database["databaseName"],
     *     name=test_aws_timestreamwrite_table["tableName"])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var test = Aws.TimestreamWrite.GetTable.Invoke(new()
     *     {
     *         DatabaseName = testAwsTimestreamwriteDatabase.DatabaseName,
     *         Name = testAwsTimestreamwriteTable.TableName,
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/timestreamwrite"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := timestreamwrite.LookupTable(ctx, &timestreamwrite.LookupTableArgs{
     * 			DatabaseName: testAwsTimestreamwriteDatabase.DatabaseName,
     * 			Name:         testAwsTimestreamwriteTable.TableName,
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.timestreamwrite.TimestreamwriteFunctions;
     * import com.pulumi.aws.timestreamwrite.inputs.GetTableArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = TimestreamwriteFunctions.getTable(GetTableArgs.builder()
     *             .databaseName(testAwsTimestreamwriteDatabase.databaseName())
     *             .name(testAwsTimestreamwriteTable.tableName())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   test:
     *     fn::invoke:
     *       Function: aws:timestreamwrite:getTable
     *       Arguments:
     *         databaseName: ${testAwsTimestreamwriteDatabase.databaseName}
     *         name: ${testAwsTimestreamwriteTable.tableName}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getTable.
     * @return A collection of values returned by getTable.
     */
    public suspend fun getTable(argument: GetTablePlainArgs): GetTableResult =
        getTableResultToKotlin(getTablePlain(argument.toJava()).await())

    /**
     * @see [getTable].
     * @param databaseName Name of the Timestream database.
     * @param name Name of the Timestream table.
     * @return A collection of values returned by getTable.
     */
    public suspend fun getTable(databaseName: String, name: String): GetTableResult {
        val argument = GetTablePlainArgs(
            databaseName = databaseName,
            name = name,
        )
        return getTableResultToKotlin(getTablePlain(argument.toJava()).await())
    }

    /**
     * @see [getTable].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;timestreamwrite&#46;kotlin&#46;inputs&#46;GetTablePlainArgs].
     * @return A collection of values returned by getTable.
     */
    public suspend fun getTable(argument: suspend GetTablePlainArgsBuilder.() -> Unit): GetTableResult {
        val builder = GetTablePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTableResultToKotlin(getTablePlain(builtArgument.toJava()).await())
    }
}
