@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.timestreamwrite.kotlin.inputs

import com.pulumi.aws.timestreamwrite.inputs.GetDatabasePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getDatabase.
 * @property name
 */
public data class GetDatabasePlainArgs(
    public val name: String,
) : ConvertibleToJava<com.pulumi.aws.timestreamwrite.inputs.GetDatabasePlainArgs> {
    override fun toJava(): com.pulumi.aws.timestreamwrite.inputs.GetDatabasePlainArgs =
        com.pulumi.aws.timestreamwrite.inputs.GetDatabasePlainArgs.builder()
            .name(name.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDatabasePlainArgs].
 */
@PulumiTagMarker
public class GetDatabasePlainArgsBuilder internal constructor() {
    private var name: String? = null

    /**
     * @param value
     */
    @JvmName("ywwarpifrwgvescy")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    internal fun build(): GetDatabasePlainArgs = GetDatabasePlainArgs(
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
