@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.timestreamwrite.kotlin.inputs

import com.pulumi.aws.timestreamwrite.inputs.GetTablePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getTable.
 * @property databaseName Name of the Timestream database.
 * @property name Name of the Timestream table.
 */
public data class GetTablePlainArgs(
    public val databaseName: String,
    public val name: String,
) : ConvertibleToJava<com.pulumi.aws.timestreamwrite.inputs.GetTablePlainArgs> {
    override fun toJava(): com.pulumi.aws.timestreamwrite.inputs.GetTablePlainArgs =
        com.pulumi.aws.timestreamwrite.inputs.GetTablePlainArgs.builder()
            .databaseName(databaseName.let({ args0 -> args0 }))
            .name(name.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTablePlainArgs].
 */
@PulumiTagMarker
public class GetTablePlainArgsBuilder internal constructor() {
    private var databaseName: String? = null

    private var name: String? = null

    /**
     * @param value Name of the Timestream database.
     */
    @JvmName("bshbujuxfpydsrsr")
    public suspend fun databaseName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.databaseName = mapped
    }

    /**
     * @param value Name of the Timestream table.
     */
    @JvmName("eqikpaqfmxbjaeor")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    internal fun build(): GetTablePlainArgs = GetTablePlainArgs(
        databaseName = databaseName ?: throw PulumiNullFieldException("databaseName"),
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
