@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.timestreamwrite.kotlin.inputs

import com.pulumi.aws.timestreamwrite.inputs.TableMagneticStoreWritePropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property enableMagneticStoreWrites A flag to enable magnetic store writes.
 * @property magneticStoreRejectedDataLocation The location to write error reports for records rejected asynchronously during magnetic store writes. See Magnetic Store Rejected Data Location below for more details.
 */
public data class TableMagneticStoreWritePropertiesArgs(
    public val enableMagneticStoreWrites: Output<Boolean>? = null,
    public val magneticStoreRejectedDataLocation: Output<TableMagneticStoreWritePropertiesMagneticStoreRejectedDataLocationArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.timestreamwrite.inputs.TableMagneticStoreWritePropertiesArgs> {
    override fun toJava(): com.pulumi.aws.timestreamwrite.inputs.TableMagneticStoreWritePropertiesArgs = com.pulumi.aws.timestreamwrite.inputs.TableMagneticStoreWritePropertiesArgs.builder()
        .enableMagneticStoreWrites(enableMagneticStoreWrites?.applyValue({ args0 -> args0 }))
        .magneticStoreRejectedDataLocation(
            magneticStoreRejectedDataLocation?.applyValue({ args0 ->
                args0.let({ args0 -> args0.toJava() })
            }),
        ).build()
}

/**
 * Builder for [TableMagneticStoreWritePropertiesArgs].
 */
@PulumiTagMarker
public class TableMagneticStoreWritePropertiesArgsBuilder internal constructor() {
    private var enableMagneticStoreWrites: Output<Boolean>? = null

    private var magneticStoreRejectedDataLocation:
        Output<TableMagneticStoreWritePropertiesMagneticStoreRejectedDataLocationArgs>? = null

    /**
     * @param value A flag to enable magnetic store writes.
     */
    @JvmName("ikbjhchpquemohhg")
    public suspend fun enableMagneticStoreWrites(`value`: Output<Boolean>) {
        this.enableMagneticStoreWrites = value
    }

    /**
     * @param value The location to write error reports for records rejected asynchronously during magnetic store writes. See Magnetic Store Rejected Data Location below for more details.
     */
    @JvmName("ivjymxarrqyxogmj")
    public suspend fun magneticStoreRejectedDataLocation(`value`: Output<TableMagneticStoreWritePropertiesMagneticStoreRejectedDataLocationArgs>) {
        this.magneticStoreRejectedDataLocation = value
    }

    /**
     * @param value A flag to enable magnetic store writes.
     */
    @JvmName("ryukqlflmdxfdopu")
    public suspend fun enableMagneticStoreWrites(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableMagneticStoreWrites = mapped
    }

    /**
     * @param value The location to write error reports for records rejected asynchronously during magnetic store writes. See Magnetic Store Rejected Data Location below for more details.
     */
    @JvmName("epxtytjqfotnpnlm")
    public suspend fun magneticStoreRejectedDataLocation(`value`: TableMagneticStoreWritePropertiesMagneticStoreRejectedDataLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.magneticStoreRejectedDataLocation = mapped
    }

    /**
     * @param argument The location to write error reports for records rejected asynchronously during magnetic store writes. See Magnetic Store Rejected Data Location below for more details.
     */
    @JvmName("qbomqbvhiuhnnnfv")
    public suspend fun magneticStoreRejectedDataLocation(argument: suspend TableMagneticStoreWritePropertiesMagneticStoreRejectedDataLocationArgsBuilder.() -> Unit) {
        val toBeMapped =
            TableMagneticStoreWritePropertiesMagneticStoreRejectedDataLocationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.magneticStoreRejectedDataLocation = mapped
    }

    internal fun build(): TableMagneticStoreWritePropertiesArgs =
        TableMagneticStoreWritePropertiesArgs(
            enableMagneticStoreWrites = enableMagneticStoreWrites,
            magneticStoreRejectedDataLocation = magneticStoreRejectedDataLocation,
        )
}
