@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.timestreamwrite.kotlin.inputs

import com.pulumi.aws.timestreamwrite.inputs.TableRetentionPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property magneticStoreRetentionPeriodInDays The duration for which data must be stored in the magnetic store. Minimum value of 1. Maximum value of 73000.
 * @property memoryStoreRetentionPeriodInHours The duration for which data must be stored in the memory store. Minimum value of 1. Maximum value of 8766.
 */
public data class TableRetentionPropertiesArgs(
    public val magneticStoreRetentionPeriodInDays: Output<Int>,
    public val memoryStoreRetentionPeriodInHours: Output<Int>,
) : ConvertibleToJava<com.pulumi.aws.timestreamwrite.inputs.TableRetentionPropertiesArgs> {
    override fun toJava(): com.pulumi.aws.timestreamwrite.inputs.TableRetentionPropertiesArgs =
        com.pulumi.aws.timestreamwrite.inputs.TableRetentionPropertiesArgs.builder()
            .magneticStoreRetentionPeriodInDays(
                magneticStoreRetentionPeriodInDays.applyValue({ args0 ->
                    args0
                }),
            )
            .memoryStoreRetentionPeriodInHours(
                memoryStoreRetentionPeriodInHours.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [TableRetentionPropertiesArgs].
 */
@PulumiTagMarker
public class TableRetentionPropertiesArgsBuilder internal constructor() {
    private var magneticStoreRetentionPeriodInDays: Output<Int>? = null

    private var memoryStoreRetentionPeriodInHours: Output<Int>? = null

    /**
     * @param value The duration for which data must be stored in the magnetic store. Minimum value of 1. Maximum value of 73000.
     */
    @JvmName("xysnfikjyijhvrlq")
    public suspend fun magneticStoreRetentionPeriodInDays(`value`: Output<Int>) {
        this.magneticStoreRetentionPeriodInDays = value
    }

    /**
     * @param value The duration for which data must be stored in the memory store. Minimum value of 1. Maximum value of 8766.
     */
    @JvmName("idipcthiggjywkim")
    public suspend fun memoryStoreRetentionPeriodInHours(`value`: Output<Int>) {
        this.memoryStoreRetentionPeriodInHours = value
    }

    /**
     * @param value The duration for which data must be stored in the magnetic store. Minimum value of 1. Maximum value of 73000.
     */
    @JvmName("iuuqhpuwbwttokos")
    public suspend fun magneticStoreRetentionPeriodInDays(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.magneticStoreRetentionPeriodInDays = mapped
    }

    /**
     * @param value The duration for which data must be stored in the memory store. Minimum value of 1. Maximum value of 8766.
     */
    @JvmName("xfsxsvjtibihsseh")
    public suspend fun memoryStoreRetentionPeriodInHours(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.memoryStoreRetentionPeriodInHours = mapped
    }

    internal fun build(): TableRetentionPropertiesArgs = TableRetentionPropertiesArgs(
        magneticStoreRetentionPeriodInDays = magneticStoreRetentionPeriodInDays ?: throw
            PulumiNullFieldException("magneticStoreRetentionPeriodInDays"),
        memoryStoreRetentionPeriodInHours = memoryStoreRetentionPeriodInHours ?: throw
            PulumiNullFieldException("memoryStoreRetentionPeriodInHours"),
    )
}
