@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.timestreamwrite.kotlin.inputs

import com.pulumi.aws.timestreamwrite.inputs.TableSchemaArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property compositePartitionKey A non-empty list of partition keys defining the attributes used to partition the table data. The order of the list determines the partition hierarchy. The name and type of each partition key as well as the partition key order cannot be changed after the table is created. However, the enforcement level of each partition key can be changed. See Composite Partition Key below for more details.
 */
public data class TableSchemaArgs(
    public val compositePartitionKey: Output<TableSchemaCompositePartitionKeyArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.timestreamwrite.inputs.TableSchemaArgs> {
    override fun toJava(): com.pulumi.aws.timestreamwrite.inputs.TableSchemaArgs =
        com.pulumi.aws.timestreamwrite.inputs.TableSchemaArgs.builder()
            .compositePartitionKey(
                compositePartitionKey?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [TableSchemaArgs].
 */
@PulumiTagMarker
public class TableSchemaArgsBuilder internal constructor() {
    private var compositePartitionKey: Output<TableSchemaCompositePartitionKeyArgs>? = null

    /**
     * @param value A non-empty list of partition keys defining the attributes used to partition the table data. The order of the list determines the partition hierarchy. The name and type of each partition key as well as the partition key order cannot be changed after the table is created. However, the enforcement level of each partition key can be changed. See Composite Partition Key below for more details.
     */
    @JvmName("vopfsawbaxjyavtt")
    public suspend fun compositePartitionKey(`value`: Output<TableSchemaCompositePartitionKeyArgs>) {
        this.compositePartitionKey = value
    }

    /**
     * @param value A non-empty list of partition keys defining the attributes used to partition the table data. The order of the list determines the partition hierarchy. The name and type of each partition key as well as the partition key order cannot be changed after the table is created. However, the enforcement level of each partition key can be changed. See Composite Partition Key below for more details.
     */
    @JvmName("mfigujcpondifufr")
    public suspend fun compositePartitionKey(`value`: TableSchemaCompositePartitionKeyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.compositePartitionKey = mapped
    }

    /**
     * @param argument A non-empty list of partition keys defining the attributes used to partition the table data. The order of the list determines the partition hierarchy. The name and type of each partition key as well as the partition key order cannot be changed after the table is created. However, the enforcement level of each partition key can be changed. See Composite Partition Key below for more details.
     */
    @JvmName("crujmxwidiqguaam")
    public suspend fun compositePartitionKey(argument: suspend TableSchemaCompositePartitionKeyArgsBuilder.() -> Unit) {
        val toBeMapped = TableSchemaCompositePartitionKeyArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.compositePartitionKey = mapped
    }

    internal fun build(): TableSchemaArgs = TableSchemaArgs(
        compositePartitionKey = compositePartitionKey,
    )
}
