@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.timestreamwrite.kotlin.inputs

import com.pulumi.aws.timestreamwrite.inputs.TableSchemaCompositePartitionKeyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property enforcementInRecord The level of enforcement for the specification of a dimension key in ingested records. Valid values: `REQUIRED`, `OPTIONAL`.
 * @property name The name of the attribute used for a dimension key.
 * @property type The type of the partition key. Valid values: `DIMENSION`, `MEASURE`.
 */
public data class TableSchemaCompositePartitionKeyArgs(
    public val enforcementInRecord: Output<String>? = null,
    public val name: Output<String>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.timestreamwrite.inputs.TableSchemaCompositePartitionKeyArgs> {
    override fun toJava(): com.pulumi.aws.timestreamwrite.inputs.TableSchemaCompositePartitionKeyArgs = com.pulumi.aws.timestreamwrite.inputs.TableSchemaCompositePartitionKeyArgs.builder()
        .enforcementInRecord(enforcementInRecord?.applyValue({ args0 -> args0 }))
        .name(name?.applyValue({ args0 -> args0 }))
        .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TableSchemaCompositePartitionKeyArgs].
 */
@PulumiTagMarker
public class TableSchemaCompositePartitionKeyArgsBuilder internal constructor() {
    private var enforcementInRecord: Output<String>? = null

    private var name: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value The level of enforcement for the specification of a dimension key in ingested records. Valid values: `REQUIRED`, `OPTIONAL`.
     */
    @JvmName("yqjgxhobhcuxxibc")
    public suspend fun enforcementInRecord(`value`: Output<String>) {
        this.enforcementInRecord = value
    }

    /**
     * @param value The name of the attribute used for a dimension key.
     */
    @JvmName("epqfkyqwacooyuxc")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The type of the partition key. Valid values: `DIMENSION`, `MEASURE`.
     */
    @JvmName("pfsbaddbrhvkocva")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The level of enforcement for the specification of a dimension key in ingested records. Valid values: `REQUIRED`, `OPTIONAL`.
     */
    @JvmName("vhnpgjlwbwnytxgv")
    public suspend fun enforcementInRecord(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enforcementInRecord = mapped
    }

    /**
     * @param value The name of the attribute used for a dimension key.
     */
    @JvmName("lrhkkialrcyuaalc")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The type of the partition key. Valid values: `DIMENSION`, `MEASURE`.
     */
    @JvmName("gsaglilihsyjeaya")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): TableSchemaCompositePartitionKeyArgs = TableSchemaCompositePartitionKeyArgs(
        enforcementInRecord = enforcementInRecord,
        name = name,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
