@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.timestreamwrite.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getDatabase.
 * @property arn The ARN that uniquely identifies this database.
 * @property createdTime Creation time of database.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property kmsKeyId The ARN of the KMS key used to encrypt the data stored in the database.
 * @property lastUpdatedTime Last time database was updated.
 * @property name
 * @property tableCount Total number of tables in the Timestream database.
 */
public data class GetDatabaseResult(
    public val arn: String,
    public val createdTime: String,
    public val id: String,
    public val kmsKeyId: String,
    public val lastUpdatedTime: String,
    public val name: String,
    public val tableCount: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.timestreamwrite.outputs.GetDatabaseResult): GetDatabaseResult = GetDatabaseResult(
            arn = javaType.arn(),
            createdTime = javaType.createdTime(),
            id = javaType.id(),
            kmsKeyId = javaType.kmsKeyId(),
            lastUpdatedTime = javaType.lastUpdatedTime(),
            name = javaType.name(),
            tableCount = javaType.tableCount(),
        )
    }
}
