@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.timestreamwrite.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property enableMagneticStoreWrites Flag that is set based on if magnetic store writes are enabled.
 * @property magneticStoreRejectedDataLocations Object containing the following attributes to describe error reports for records rejected during magnetic store writes.
 */
public data class GetTableMagneticStoreWriteProperty(
    public val enableMagneticStoreWrites: Boolean,
    public val magneticStoreRejectedDataLocations: List<GetTableMagneticStoreWritePropertyMagneticStoreRejectedDataLocation>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.timestreamwrite.outputs.GetTableMagneticStoreWriteProperty): GetTableMagneticStoreWriteProperty = GetTableMagneticStoreWriteProperty(
            enableMagneticStoreWrites = javaType.enableMagneticStoreWrites(),
            magneticStoreRejectedDataLocations = javaType.magneticStoreRejectedDataLocations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.timestreamwrite.kotlin.outputs.GetTableMagneticStoreWritePropertyMagneticStoreRejectedDataLocation.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
