@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.timestreamwrite.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getTable.
 * @property arn ARN that uniquely identifies the table.
 * @property creationTime Time that table was created.
 * @property databaseName Name of database.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property lastUpdatedTime Last time table was updated.
 * @property magneticStoreWriteProperties Object containing the following attributes to desribe magnetic store writes.
 * @property name Name of the table.
 * @property retentionProperties Object containing the following attributes to describe the retention duration for the memory and magnetic stores.
 * @property schemas Object containing the following attributes to describe the schema of the table.
 * @property tableStatus Current state of table.
 */
public data class GetTableResult(
    public val arn: String,
    public val creationTime: String,
    public val databaseName: String,
    public val id: String,
    public val lastUpdatedTime: String,
    public val magneticStoreWriteProperties: List<GetTableMagneticStoreWriteProperty>,
    public val name: String,
    public val retentionProperties: List<GetTableRetentionProperty>,
    public val schemas: List<GetTableSchema>,
    public val tableStatus: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.timestreamwrite.outputs.GetTableResult): GetTableResult = GetTableResult(
            arn = javaType.arn(),
            creationTime = javaType.creationTime(),
            databaseName = javaType.databaseName(),
            id = javaType.id(),
            lastUpdatedTime = javaType.lastUpdatedTime(),
            magneticStoreWriteProperties = javaType.magneticStoreWriteProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.timestreamwrite.kotlin.outputs.GetTableMagneticStoreWriteProperty.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name(),
            retentionProperties = javaType.retentionProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.timestreamwrite.kotlin.outputs.GetTableRetentionProperty.Companion.toKotlin(args0)
                })
            }),
            schemas = javaType.schemas().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.timestreamwrite.kotlin.outputs.GetTableSchema.Companion.toKotlin(args0)
                })
            }),
            tableStatus = javaType.tableStatus(),
        )
    }
}
