@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.timestreamwrite.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property magneticStoreRetentionPeriodInDays Duration in days in which the data must be stored in magnetic store.
 * @property memoryStoreRetentionPeriodInHours Duration in hours in which the data must be stored in memory store.
 */
public data class GetTableRetentionProperty(
    public val magneticStoreRetentionPeriodInDays: Int,
    public val memoryStoreRetentionPeriodInHours: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.timestreamwrite.outputs.GetTableRetentionProperty): GetTableRetentionProperty = GetTableRetentionProperty(
            magneticStoreRetentionPeriodInDays = javaType.magneticStoreRetentionPeriodInDays(),
            memoryStoreRetentionPeriodInHours = javaType.memoryStoreRetentionPeriodInHours(),
        )
    }
}
