@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.timestreamwrite.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property compositePartitionKey A non-empty list of partition keys defining the attributes used to partition the table data. The order of the list determines the partition hierarchy. The name and type of each partition key as well as the partition key order cannot be changed after the table is created. However, the enforcement level of each partition key can be changed. See Composite Partition Key below for more details.
 */
public data class TableSchema(
    public val compositePartitionKey: TableSchemaCompositePartitionKey? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.timestreamwrite.outputs.TableSchema): TableSchema =
            TableSchema(
                compositePartitionKey = javaType.compositePartitionKey().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.timestreamwrite.kotlin.outputs.TableSchemaCompositePartitionKey.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
