@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.transcribe.kotlin

import com.pulumi.aws.transcribe.MedicalVocabularyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS Transcribe MedicalVocabulary.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.s3.BucketV2("example", {
 *     bucket: "example-medical-vocab-123",
 *     forceDestroy: true,
 * });
 * const object = new aws.s3.BucketObjectv2("object", {
 *     bucket: example.id,
 *     key: "transcribe/test1.txt",
 *     source: new pulumi.asset.FileAsset("test.txt"),
 * });
 * const exampleMedicalVocabulary = new aws.transcribe.MedicalVocabulary("example", {
 *     vocabularyName: "example",
 *     languageCode: "en-US",
 *     vocabularyFileUri: pulumi.interpolate`s3://${example.id}/${object.key}`,
 *     tags: {
 *         tag1: "value1",
 *         tag2: "value3",
 *     },
 * }, {
 *     dependsOn: [object],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.s3.BucketV2("example",
 *     bucket="example-medical-vocab-123",
 *     force_destroy=True)
 * object = aws.s3.BucketObjectv2("object",
 *     bucket=example.id,
 *     key="transcribe/test1.txt",
 *     source=pulumi.FileAsset("test.txt"))
 * example_medical_vocabulary = aws.transcribe.MedicalVocabulary("example",
 *     vocabulary_name="example",
 *     language_code="en-US",
 *     vocabulary_file_uri=pulumi.Output.all(example.id, object.key).apply(lambda id, key: f"s3://{id}/{key}"),
 *     tags={
 *         "tag1": "value1",
 *         "tag2": "value3",
 *     },
 *     opts = pulumi.ResourceOptions(depends_on=[object]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.S3.BucketV2("example", new()
 *     {
 *         Bucket = "example-medical-vocab-123",
 *         ForceDestroy = true,
 *     });
 *     var @object = new Aws.S3.BucketObjectv2("object", new()
 *     {
 *         Bucket = example.Id,
 *         Key = "transcribe/test1.txt",
 *         Source = new FileAsset("test.txt"),
 *     });
 *     var exampleMedicalVocabulary = new Aws.Transcribe.MedicalVocabulary("example", new()
 *     {
 *         VocabularyName = "example",
 *         LanguageCode = "en-US",
 *         VocabularyFileUri = Output.Tuple(example.Id, @object.Key).Apply(values =>
 *         {
 *             var id = values.Item1;
 *             var key = values.Item2;
 *             return $"s3://{id}/{key}";
 *         }),
 *         Tags =
 *         {
 *             { "tag1", "value1" },
 *             { "tag2", "value3" },
 *         },
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             @object,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/transcribe"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := s3.NewBucketV2(ctx, "example", &s3.BucketV2Args{
 * 			Bucket:       pulumi.String("example-medical-vocab-123"),
 * 			ForceDestroy: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		object, err := s3.NewBucketObjectv2(ctx, "object", &s3.BucketObjectv2Args{
 * 			Bucket: example.ID(),
 * 			Key:    pulumi.String("transcribe/test1.txt"),
 * 			Source: pulumi.NewFileAsset("test.txt"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = transcribe.NewMedicalVocabulary(ctx, "example", &transcribe.MedicalVocabularyArgs{
 * 			VocabularyName: pulumi.String("example"),
 * 			LanguageCode:   pulumi.String("en-US"),
 * 			VocabularyFileUri: pulumi.All(example.ID(), object.Key).ApplyT(func(_args []interface{}) (string, error) {
 * 				id := _args[0].(string)
 * 				key := _args[1].(string)
 * 				return fmt.Sprintf("s3://%v/%v", id, key), nil
 * 			}).(pulumi.StringOutput),
 * 			Tags: pulumi.StringMap{
 * 				"tag1": pulumi.String("value1"),
 * 				"tag2": pulumi.String("value3"),
 * 			},
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			object,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.s3.BucketObjectv2;
 * import com.pulumi.aws.s3.BucketObjectv2Args;
 * import com.pulumi.aws.transcribe.MedicalVocabulary;
 * import com.pulumi.aws.transcribe.MedicalVocabularyArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import com.pulumi.asset.FileAsset;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new BucketV2("example", BucketV2Args.builder()
 *             .bucket("example-medical-vocab-123")
 *             .forceDestroy(true)
 *             .build());
 *         var object = new BucketObjectv2("object", BucketObjectv2Args.builder()
 *             .bucket(example.id())
 *             .key("transcribe/test1.txt")
 *             .source(new FileAsset("test.txt"))
 *             .build());
 *         var exampleMedicalVocabulary = new MedicalVocabulary("exampleMedicalVocabulary", MedicalVocabularyArgs.builder()
 *             .vocabularyName("example")
 *             .languageCode("en-US")
 *             .vocabularyFileUri(Output.tuple(example.id(), object.key()).applyValue(values -> {
 *                 var id = values.t1;
 *                 var key = values.t2;
 *                 return String.format("s3://%s/%s", id,key);
 *             }))
 *             .tags(Map.ofEntries(
 *                 Map.entry("tag1", "value1"),
 *                 Map.entry("tag2", "value3")
 *             ))
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(object)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:s3:BucketV2
 *     properties:
 *       bucket: example-medical-vocab-123
 *       forceDestroy: true
 *   object:
 *     type: aws:s3:BucketObjectv2
 *     properties:
 *       bucket: ${example.id}
 *       key: transcribe/test1.txt
 *       source:
 *         fn::FileAsset: test.txt
 *   exampleMedicalVocabulary:
 *     type: aws:transcribe:MedicalVocabulary
 *     name: example
 *     properties:
 *       vocabularyName: example
 *       languageCode: en-US
 *       vocabularyFileUri: s3://${example.id}/${object.key}
 *       tags:
 *         tag1: value1
 *         tag2: value3
 *     options:
 *       dependson:
 *         - ${object}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Transcribe MedicalVocabulary using the `vocabulary_name`. For example:
 * ```sh
 * $ pulumi import aws:transcribe/medicalVocabulary:MedicalVocabulary example example-name
 * ```
 * @property languageCode The language code you selected for your medical vocabulary. US English (en-US) is the only language supported with Amazon Transcribe Medical.
 * @property tags A map of tags to assign to the MedicalVocabulary. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property vocabularyFileUri The Amazon S3 location (URI) of the text file that contains your custom medical vocabulary.
 * @property vocabularyName The name of the Medical Vocabulary.
 * The following arguments are optional:
 */
public data class MedicalVocabularyArgs(
    public val languageCode: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vocabularyFileUri: Output<String>? = null,
    public val vocabularyName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.transcribe.MedicalVocabularyArgs> {
    override fun toJava(): com.pulumi.aws.transcribe.MedicalVocabularyArgs =
        com.pulumi.aws.transcribe.MedicalVocabularyArgs.builder()
            .languageCode(languageCode?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vocabularyFileUri(vocabularyFileUri?.applyValue({ args0 -> args0 }))
            .vocabularyName(vocabularyName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MedicalVocabularyArgs].
 */
@PulumiTagMarker
public class MedicalVocabularyArgsBuilder internal constructor() {
    private var languageCode: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vocabularyFileUri: Output<String>? = null

    private var vocabularyName: Output<String>? = null

    /**
     * @param value The language code you selected for your medical vocabulary. US English (en-US) is the only language supported with Amazon Transcribe Medical.
     */
    @JvmName("qqgvfdimxuhifvww")
    public suspend fun languageCode(`value`: Output<String>) {
        this.languageCode = value
    }

    /**
     * @param value A map of tags to assign to the MedicalVocabulary. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("wwuiwglddxeuusku")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The Amazon S3 location (URI) of the text file that contains your custom medical vocabulary.
     */
    @JvmName("ctuhmhfpfcyplcgj")
    public suspend fun vocabularyFileUri(`value`: Output<String>) {
        this.vocabularyFileUri = value
    }

    /**
     * @param value The name of the Medical Vocabulary.
     * The following arguments are optional:
     */
    @JvmName("agscxxdxfkughpwq")
    public suspend fun vocabularyName(`value`: Output<String>) {
        this.vocabularyName = value
    }

    /**
     * @param value The language code you selected for your medical vocabulary. US English (en-US) is the only language supported with Amazon Transcribe Medical.
     */
    @JvmName("nnqyhqddacybidbb")
    public suspend fun languageCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.languageCode = mapped
    }

    /**
     * @param value A map of tags to assign to the MedicalVocabulary. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("rhrsljafbaixucpg")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the MedicalVocabulary. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("pgflvohqtrnjswhq")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The Amazon S3 location (URI) of the text file that contains your custom medical vocabulary.
     */
    @JvmName("yqdffhvvsaqjkhqa")
    public suspend fun vocabularyFileUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vocabularyFileUri = mapped
    }

    /**
     * @param value The name of the Medical Vocabulary.
     * The following arguments are optional:
     */
    @JvmName("bitmdrtcuojubmqt")
    public suspend fun vocabularyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vocabularyName = mapped
    }

    internal fun build(): MedicalVocabularyArgs = MedicalVocabularyArgs(
        languageCode = languageCode,
        tags = tags,
        vocabularyFileUri = vocabularyFileUri,
        vocabularyName = vocabularyName,
    )
}
