@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.transcribe.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [Vocabulary].
 */
@PulumiTagMarker
public class VocabularyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VocabularyArgs = VocabularyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VocabularyArgsBuilder.() -> Unit) {
        val builder = VocabularyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Vocabulary {
        val builtJavaResource = com.pulumi.aws.transcribe.Vocabulary(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Vocabulary(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS Transcribe Vocabulary.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.s3.BucketV2("example", {
 *     bucket: "example-vocab-123",
 *     forceDestroy: true,
 * });
 * const object = new aws.s3.BucketObjectv2("object", {
 *     bucket: example.id,
 *     key: "transcribe/test1.txt",
 *     source: new pulumi.asset.FileAsset("test.txt"),
 * });
 * const exampleVocabulary = new aws.transcribe.Vocabulary("example", {
 *     vocabularyName: "example",
 *     languageCode: "en-US",
 *     vocabularyFileUri: pulumi.interpolate`s3://${example.id}/${object.key}`,
 *     tags: {
 *         tag1: "value1",
 *         tag2: "value3",
 *     },
 * }, {
 *     dependsOn: [object],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.s3.BucketV2("example",
 *     bucket="example-vocab-123",
 *     force_destroy=True)
 * object = aws.s3.BucketObjectv2("object",
 *     bucket=example.id,
 *     key="transcribe/test1.txt",
 *     source=pulumi.FileAsset("test.txt"))
 * example_vocabulary = aws.transcribe.Vocabulary("example",
 *     vocabulary_name="example",
 *     language_code="en-US",
 *     vocabulary_file_uri=pulumi.Output.all(example.id, object.key).apply(lambda id, key: f"s3://{id}/{key}"),
 *     tags={
 *         "tag1": "value1",
 *         "tag2": "value3",
 *     },
 *     opts = pulumi.ResourceOptions(depends_on=[object]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.S3.BucketV2("example", new()
 *     {
 *         Bucket = "example-vocab-123",
 *         ForceDestroy = true,
 *     });
 *     var @object = new Aws.S3.BucketObjectv2("object", new()
 *     {
 *         Bucket = example.Id,
 *         Key = "transcribe/test1.txt",
 *         Source = new FileAsset("test.txt"),
 *     });
 *     var exampleVocabulary = new Aws.Transcribe.Vocabulary("example", new()
 *     {
 *         VocabularyName = "example",
 *         LanguageCode = "en-US",
 *         VocabularyFileUri = Output.Tuple(example.Id, @object.Key).Apply(values =>
 *         {
 *             var id = values.Item1;
 *             var key = values.Item2;
 *             return $"s3://{id}/{key}";
 *         }),
 *         Tags =
 *         {
 *             { "tag1", "value1" },
 *             { "tag2", "value3" },
 *         },
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             @object,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/transcribe"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := s3.NewBucketV2(ctx, "example", &s3.BucketV2Args{
 * 			Bucket:       pulumi.String("example-vocab-123"),
 * 			ForceDestroy: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		object, err := s3.NewBucketObjectv2(ctx, "object", &s3.BucketObjectv2Args{
 * 			Bucket: example.ID(),
 * 			Key:    pulumi.String("transcribe/test1.txt"),
 * 			Source: pulumi.NewFileAsset("test.txt"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = transcribe.NewVocabulary(ctx, "example", &transcribe.VocabularyArgs{
 * 			VocabularyName: pulumi.String("example"),
 * 			LanguageCode:   pulumi.String("en-US"),
 * 			VocabularyFileUri: pulumi.All(example.ID(), object.Key).ApplyT(func(_args []interface{}) (string, error) {
 * 				id := _args[0].(string)
 * 				key := _args[1].(string)
 * 				return fmt.Sprintf("s3://%v/%v", id, key), nil
 * 			}).(pulumi.StringOutput),
 * 			Tags: pulumi.StringMap{
 * 				"tag1": pulumi.String("value1"),
 * 				"tag2": pulumi.String("value3"),
 * 			},
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			object,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.s3.BucketObjectv2;
 * import com.pulumi.aws.s3.BucketObjectv2Args;
 * import com.pulumi.aws.transcribe.Vocabulary;
 * import com.pulumi.aws.transcribe.VocabularyArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import com.pulumi.asset.FileAsset;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new BucketV2("example", BucketV2Args.builder()
 *             .bucket("example-vocab-123")
 *             .forceDestroy(true)
 *             .build());
 *         var object = new BucketObjectv2("object", BucketObjectv2Args.builder()
 *             .bucket(example.id())
 *             .key("transcribe/test1.txt")
 *             .source(new FileAsset("test.txt"))
 *             .build());
 *         var exampleVocabulary = new Vocabulary("exampleVocabulary", VocabularyArgs.builder()
 *             .vocabularyName("example")
 *             .languageCode("en-US")
 *             .vocabularyFileUri(Output.tuple(example.id(), object.key()).applyValue(values -> {
 *                 var id = values.t1;
 *                 var key = values.t2;
 *                 return String.format("s3://%s/%s", id,key);
 *             }))
 *             .tags(Map.ofEntries(
 *                 Map.entry("tag1", "value1"),
 *                 Map.entry("tag2", "value3")
 *             ))
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(object)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:s3:BucketV2
 *     properties:
 *       bucket: example-vocab-123
 *       forceDestroy: true
 *   object:
 *     type: aws:s3:BucketObjectv2
 *     properties:
 *       bucket: ${example.id}
 *       key: transcribe/test1.txt
 *       source:
 *         fn::FileAsset: test.txt
 *   exampleVocabulary:
 *     type: aws:transcribe:Vocabulary
 *     name: example
 *     properties:
 *       vocabularyName: example
 *       languageCode: en-US
 *       vocabularyFileUri: s3://${example.id}/${object.key}
 *       tags:
 *         tag1: value1
 *         tag2: value3
 *     options:
 *       dependson:
 *         - ${object}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Transcribe Vocabulary using the `vocabulary_name`. For example:
 * ```sh
 * $ pulumi import aws:transcribe/vocabulary:Vocabulary example example-name
 * ```
 */
public class Vocabulary internal constructor(
    override val javaResource: com.pulumi.aws.transcribe.Vocabulary,
) : KotlinCustomResource(javaResource, VocabularyMapper) {
    /**
     * ARN of the Vocabulary.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Generated download URI.
     */
    public val downloadUri: Output<String>
        get() = javaResource.downloadUri().applyValue({ args0 -> args0 })

    /**
     * The language code you selected for your vocabulary.
     */
    public val languageCode: Output<String>
        get() = javaResource.languageCode().applyValue({ args0 -> args0 })

    /**
     * A list of terms to include in the vocabulary. Conflicts with `vocabulary_file_uri`
     */
    public val phrases: Output<List<String>>?
        get() = javaResource.phrases().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * A map of tags to assign to the Vocabulary. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The Amazon S3 location (URI) of the text file that contains your custom vocabulary. Conflicts wth `phrases`.
     */
    public val vocabularyFileUri: Output<String>
        get() = javaResource.vocabularyFileUri().applyValue({ args0 -> args0 })

    /**
     * The name of the Vocabulary.
     * The following arguments are optional:
     */
    public val vocabularyName: Output<String>
        get() = javaResource.vocabularyName().applyValue({ args0 -> args0 })
}

public object VocabularyMapper : ResourceMapper<Vocabulary> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.transcribe.Vocabulary::class == javaResource::class

    override fun map(javaResource: Resource): Vocabulary = Vocabulary(
        javaResource as
            com.pulumi.aws.transcribe.Vocabulary,
    )
}

/**
 * @see [Vocabulary].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Vocabulary].
 */
public suspend fun vocabulary(name: String, block: suspend VocabularyResourceBuilder.() -> Unit): Vocabulary {
    val builder = VocabularyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Vocabulary].
 * @param name The _unique_ name of the resulting resource.
 */
public fun vocabulary(name: String): Vocabulary {
    val builder = VocabularyResourceBuilder()
    builder.name(name)
    return builder.build()
}
