@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.transcribe.kotlin

import com.pulumi.aws.transcribe.VocabularyFilterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS Transcribe VocabularyFilter.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.transcribe.VocabularyFilter("example", {
 *     vocabularyFilterName: "example",
 *     languageCode: "en-US",
 *     words: [
 *         "cars",
 *         "bucket",
 *     ],
 *     tags: {
 *         tag1: "value1",
 *         tag2: "value3",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.transcribe.VocabularyFilter("example",
 *     vocabulary_filter_name="example",
 *     language_code="en-US",
 *     words=[
 *         "cars",
 *         "bucket",
 *     ],
 *     tags={
 *         "tag1": "value1",
 *         "tag2": "value3",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Transcribe.VocabularyFilter("example", new()
 *     {
 *         VocabularyFilterName = "example",
 *         LanguageCode = "en-US",
 *         Words = new[]
 *         {
 *             "cars",
 *             "bucket",
 *         },
 *         Tags =
 *         {
 *             { "tag1", "value1" },
 *             { "tag2", "value3" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/transcribe"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := transcribe.NewVocabularyFilter(ctx, "example", &transcribe.VocabularyFilterArgs{
 * 			VocabularyFilterName: pulumi.String("example"),
 * 			LanguageCode:         pulumi.String("en-US"),
 * 			Words: pulumi.StringArray{
 * 				pulumi.String("cars"),
 * 				pulumi.String("bucket"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"tag1": pulumi.String("value1"),
 * 				"tag2": pulumi.String("value3"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.transcribe.VocabularyFilter;
 * import com.pulumi.aws.transcribe.VocabularyFilterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new VocabularyFilter("example", VocabularyFilterArgs.builder()
 *             .vocabularyFilterName("example")
 *             .languageCode("en-US")
 *             .words(
 *                 "cars",
 *                 "bucket")
 *             .tags(Map.ofEntries(
 *                 Map.entry("tag1", "value1"),
 *                 Map.entry("tag2", "value3")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:transcribe:VocabularyFilter
 *     properties:
 *       vocabularyFilterName: example
 *       languageCode: en-US
 *       words:
 *         - cars
 *         - bucket
 *       tags:
 *         tag1: value1
 *         tag2: value3
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Transcribe VocabularyFilter using the `vocabulary_filter_name`. For example:
 * ```sh
 * $ pulumi import aws:transcribe/vocabularyFilter:VocabularyFilter example example-name
 * ```
 * @property languageCode The language code you selected for your vocabulary filter. Refer to the [supported languages](https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html) page for accepted codes.
 * @property tags A map of tags to assign to the VocabularyFilter. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property vocabularyFilterFileUri The Amazon S3 location (URI) of the text file that contains your custom VocabularyFilter. Conflicts with `words` argument.
 * @property vocabularyFilterName The name of the VocabularyFilter.
 * The following arguments are optional:
 * @property words A list of terms to include in the vocabulary. Conflicts with `vocabulary_filter_file_uri` argument.
 */
public data class VocabularyFilterArgs(
    public val languageCode: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vocabularyFilterFileUri: Output<String>? = null,
    public val vocabularyFilterName: Output<String>? = null,
    public val words: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.transcribe.VocabularyFilterArgs> {
    override fun toJava(): com.pulumi.aws.transcribe.VocabularyFilterArgs =
        com.pulumi.aws.transcribe.VocabularyFilterArgs.builder()
            .languageCode(languageCode?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vocabularyFilterFileUri(vocabularyFilterFileUri?.applyValue({ args0 -> args0 }))
            .vocabularyFilterName(vocabularyFilterName?.applyValue({ args0 -> args0 }))
            .words(words?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [VocabularyFilterArgs].
 */
@PulumiTagMarker
public class VocabularyFilterArgsBuilder internal constructor() {
    private var languageCode: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vocabularyFilterFileUri: Output<String>? = null

    private var vocabularyFilterName: Output<String>? = null

    private var words: Output<List<String>>? = null

    /**
     * @param value The language code you selected for your vocabulary filter. Refer to the [supported languages](https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html) page for accepted codes.
     */
    @JvmName("dvblinqdjxwfsicp")
    public suspend fun languageCode(`value`: Output<String>) {
        this.languageCode = value
    }

    /**
     * @param value A map of tags to assign to the VocabularyFilter. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ebvqhtehobteyqll")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The Amazon S3 location (URI) of the text file that contains your custom VocabularyFilter. Conflicts with `words` argument.
     */
    @JvmName("fgjethhmpvebrbox")
    public suspend fun vocabularyFilterFileUri(`value`: Output<String>) {
        this.vocabularyFilterFileUri = value
    }

    /**
     * @param value The name of the VocabularyFilter.
     * The following arguments are optional:
     */
    @JvmName("nhsniyvfyajkeagq")
    public suspend fun vocabularyFilterName(`value`: Output<String>) {
        this.vocabularyFilterName = value
    }

    /**
     * @param value A list of terms to include in the vocabulary. Conflicts with `vocabulary_filter_file_uri` argument.
     */
    @JvmName("igyirlafbfnheywj")
    public suspend fun words(`value`: Output<List<String>>) {
        this.words = value
    }

    @JvmName("mkmtdnawwirlfveo")
    public suspend fun words(vararg values: Output<String>) {
        this.words = Output.all(values.asList())
    }

    /**
     * @param values A list of terms to include in the vocabulary. Conflicts with `vocabulary_filter_file_uri` argument.
     */
    @JvmName("fjptainkcofmbpgy")
    public suspend fun words(values: List<Output<String>>) {
        this.words = Output.all(values)
    }

    /**
     * @param value The language code you selected for your vocabulary filter. Refer to the [supported languages](https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html) page for accepted codes.
     */
    @JvmName("nbaworpawdqisgkd")
    public suspend fun languageCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.languageCode = mapped
    }

    /**
     * @param value A map of tags to assign to the VocabularyFilter. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("rrydcffgwamnlsii")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the VocabularyFilter. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("yxgdqhhvskmkfbic")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The Amazon S3 location (URI) of the text file that contains your custom VocabularyFilter. Conflicts with `words` argument.
     */
    @JvmName("uadxgmpvmefsmkow")
    public suspend fun vocabularyFilterFileUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vocabularyFilterFileUri = mapped
    }

    /**
     * @param value The name of the VocabularyFilter.
     * The following arguments are optional:
     */
    @JvmName("eckoescmlpjjxyas")
    public suspend fun vocabularyFilterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vocabularyFilterName = mapped
    }

    /**
     * @param value A list of terms to include in the vocabulary. Conflicts with `vocabulary_filter_file_uri` argument.
     */
    @JvmName("jrwypriwukbcvkuu")
    public suspend fun words(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.words = mapped
    }

    /**
     * @param values A list of terms to include in the vocabulary. Conflicts with `vocabulary_filter_file_uri` argument.
     */
    @JvmName("qsyynghrwoijgogh")
    public suspend fun words(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.words = mapped
    }

    internal fun build(): VocabularyFilterArgs = VocabularyFilterArgs(
        languageCode = languageCode,
        tags = tags,
        vocabularyFilterFileUri = vocabularyFilterFileUri,
        vocabularyFilterName = vocabularyFilterName,
        words = words,
    )
}
