@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.transfer.kotlin

import com.pulumi.aws.transfer.kotlin.outputs.AccessHomeDirectoryMapping
import com.pulumi.aws.transfer.kotlin.outputs.AccessPosixProfile
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.aws.transfer.kotlin.outputs.AccessHomeDirectoryMapping.Companion.toKotlin as accessHomeDirectoryMappingToKotlin
import com.pulumi.aws.transfer.kotlin.outputs.AccessPosixProfile.Companion.toKotlin as accessPosixProfileToKotlin

/**
 * Builder for [Access].
 */
@PulumiTagMarker
public class AccessResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AccessArgs = AccessArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AccessArgsBuilder.() -> Unit) {
        val builder = AccessArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Access {
        val builtJavaResource = com.pulumi.aws.transfer.Access(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Access(builtJavaResource)
    }
}

/**
 * Provides a AWS Transfer Access resource.
 * > **NOTE:** We suggest using explicit JSON encoding or `aws.iam.getPolicyDocument` when assigning a value to `policy`. They seamlessly translate configuration to JSON, enabling you to maintain consistency within your configuration without the need for context switches. Also, you can sidestep potential complications arising from formatting discrepancies, whitespace inconsistencies, and other nuances inherent to JSON.
 * ## Example Usage
 * ### Basic S3
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.transfer.Access("example", {
 *     externalId: "S-1-1-12-1234567890-123456789-1234567890-1234",
 *     serverId: exampleAwsTransferServer.id,
 *     role: exampleAwsIamRole.arn,
 *     homeDirectory: `/${exampleAwsS3Bucket.id}/`,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.transfer.Access("example",
 *     external_id="S-1-1-12-1234567890-123456789-1234567890-1234",
 *     server_id=example_aws_transfer_server["id"],
 *     role=example_aws_iam_role["arn"],
 *     home_directory=f"/{example_aws_s3_bucket['id']}/")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Transfer.Access("example", new()
 *     {
 *         ExternalId = "S-1-1-12-1234567890-123456789-1234567890-1234",
 *         ServerId = exampleAwsTransferServer.Id,
 *         Role = exampleAwsIamRole.Arn,
 *         HomeDirectory = $"/{exampleAwsS3Bucket.Id}/",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/transfer"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := transfer.NewAccess(ctx, "example", &transfer.AccessArgs{
 * 			ExternalId:    pulumi.String("S-1-1-12-1234567890-123456789-1234567890-1234"),
 * 			ServerId:      pulumi.Any(exampleAwsTransferServer.Id),
 * 			Role:          pulumi.Any(exampleAwsIamRole.Arn),
 * 			HomeDirectory: pulumi.Sprintf("/%v/", exampleAwsS3Bucket.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.transfer.Access;
 * import com.pulumi.aws.transfer.AccessArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Access("example", AccessArgs.builder()
 *             .externalId("S-1-1-12-1234567890-123456789-1234567890-1234")
 *             .serverId(exampleAwsTransferServer.id())
 *             .role(exampleAwsIamRole.arn())
 *             .homeDirectory(String.format("/%s/", exampleAwsS3Bucket.id()))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:transfer:Access
 *     properties:
 *       externalId: S-1-1-12-1234567890-123456789-1234567890-1234
 *       serverId: ${exampleAwsTransferServer.id}
 *       role: ${exampleAwsIamRole.arn}
 *       homeDirectory: /${exampleAwsS3Bucket.id}/
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Basic EFS
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.transfer.Access("test", {
 *     externalId: "S-1-1-12-1234567890-123456789-1234567890-1234",
 *     serverId: testAwsTransferServer.id,
 *     role: testAwsIamRole.arn,
 *     homeDirectory: `/${testAwsEfsFileSystem.id}/`,
 *     posixProfile: {
 *         gid: 1000,
 *         uid: 1000,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.transfer.Access("test",
 *     external_id="S-1-1-12-1234567890-123456789-1234567890-1234",
 *     server_id=test_aws_transfer_server["id"],
 *     role=test_aws_iam_role["arn"],
 *     home_directory=f"/{test_aws_efs_file_system['id']}/",
 *     posix_profile={
 *         "gid": 1000,
 *         "uid": 1000,
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.Transfer.Access("test", new()
 *     {
 *         ExternalId = "S-1-1-12-1234567890-123456789-1234567890-1234",
 *         ServerId = testAwsTransferServer.Id,
 *         Role = testAwsIamRole.Arn,
 *         HomeDirectory = $"/{testAwsEfsFileSystem.Id}/",
 *         PosixProfile = new Aws.Transfer.Inputs.AccessPosixProfileArgs
 *         {
 *             Gid = 1000,
 *             Uid = 1000,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/transfer"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := transfer.NewAccess(ctx, "test", &transfer.AccessArgs{
 * 			ExternalId:    pulumi.String("S-1-1-12-1234567890-123456789-1234567890-1234"),
 * 			ServerId:      pulumi.Any(testAwsTransferServer.Id),
 * 			Role:          pulumi.Any(testAwsIamRole.Arn),
 * 			HomeDirectory: pulumi.Sprintf("/%v/", testAwsEfsFileSystem.Id),
 * 			PosixProfile: &transfer.AccessPosixProfileArgs{
 * 				Gid: pulumi.Int(1000),
 * 				Uid: pulumi.Int(1000),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.transfer.Access;
 * import com.pulumi.aws.transfer.AccessArgs;
 * import com.pulumi.aws.transfer.inputs.AccessPosixProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Access("test", AccessArgs.builder()
 *             .externalId("S-1-1-12-1234567890-123456789-1234567890-1234")
 *             .serverId(testAwsTransferServer.id())
 *             .role(testAwsIamRole.arn())
 *             .homeDirectory(String.format("/%s/", testAwsEfsFileSystem.id()))
 *             .posixProfile(AccessPosixProfileArgs.builder()
 *                 .gid(1000)
 *                 .uid(1000)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:transfer:Access
 *     properties:
 *       externalId: S-1-1-12-1234567890-123456789-1234567890-1234
 *       serverId: ${testAwsTransferServer.id}
 *       role: ${testAwsIamRole.arn}
 *       homeDirectory: /${testAwsEfsFileSystem.id}/
 *       posixProfile:
 *         gid: 1000
 *         uid: 1000
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Transfer Accesses using the `server_id` and `external_id`. For example:
 * ```sh
 * $ pulumi import aws:transfer/access:Access example s-12345678/S-1-1-12-1234567890-123456789-1234567890-1234
 * ```
 */
public class Access internal constructor(
    override val javaResource: com.pulumi.aws.transfer.Access,
) : KotlinCustomResource(javaResource, AccessMapper) {
    /**
     * The SID of a group in the directory connected to the Transfer Server (e.g., `S-1-1-12-1234567890-123456789-1234567890-1234`)
     */
    public val externalId: Output<String>
        get() = javaResource.externalId().applyValue({ args0 -> args0 })

    /**
     * The landing directory (folder) for a user when they log in to the server using their SFTP client.  It should begin with a `/`.  The first item in the path is the name of the home bucket (accessible as `${Transfer:HomeBucket}` in the policy) and the rest is the home directory (accessible as `${Transfer:HomeDirectory}` in the policy). For example, `/example-bucket-1234/username` would set the home bucket to `example-bucket-1234` and the home directory to `username`.
     */
    public val homeDirectory: Output<String>?
        get() = javaResource.homeDirectory().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Logical directory mappings that specify what S3 paths and keys should be visible to your user and how you want to make them visible. See Home Directory Mappings below.
     */
    public val homeDirectoryMappings: Output<List<AccessHomeDirectoryMapping>>?
        get() = javaResource.homeDirectoryMappings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        accessHomeDirectoryMappingToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The type of landing directory (folder) you mapped for your users' home directory. Valid values are `PATH` and `LOGICAL`.
     */
    public val homeDirectoryType: Output<String>?
        get() = javaResource.homeDirectoryType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * An IAM JSON policy document that scopes down user access to portions of their Amazon S3 bucket. IAM variables you can use inside this policy include `${Transfer:UserName}`, `${Transfer:HomeDirectory}`, and `${Transfer:HomeBucket}`. These are evaluated on-the-fly when navigating the bucket.
     */
    public val policy: Output<String>?
        get() = javaResource.policy().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Specifies the full POSIX identity, including user ID (Uid), group ID (Gid), and any secondary groups IDs (SecondaryGids), that controls your users' access to your Amazon EFS file systems. See Posix Profile below.
     */
    public val posixProfile: Output<AccessPosixProfile>?
        get() = javaResource.posixProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    accessPosixProfileToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Amazon Resource Name (ARN) of an IAM role that allows the service to controls your user’s access to your Amazon S3 bucket.
     */
    public val role: Output<String>?
        get() = javaResource.role().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The Server ID of the Transfer Server (e.g., `s-12345678`)
     */
    public val serverId: Output<String>
        get() = javaResource.serverId().applyValue({ args0 -> args0 })
}

public object AccessMapper : ResourceMapper<Access> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.transfer.Access::class == javaResource::class

    override fun map(javaResource: Resource): Access = Access(
        javaResource as
            com.pulumi.aws.transfer.Access,
    )
}

/**
 * @see [Access].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Access].
 */
public suspend fun access(name: String, block: suspend AccessResourceBuilder.() -> Unit): Access {
    val builder = AccessResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Access].
 * @param name The _unique_ name of the resulting resource.
 */
public fun access(name: String): Access {
    val builder = AccessResourceBuilder()
    builder.name(name)
    return builder.build()
}
