@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.transfer.kotlin

import com.pulumi.aws.transfer.AccessArgs.builder
import com.pulumi.aws.transfer.kotlin.inputs.AccessHomeDirectoryMappingArgs
import com.pulumi.aws.transfer.kotlin.inputs.AccessHomeDirectoryMappingArgsBuilder
import com.pulumi.aws.transfer.kotlin.inputs.AccessPosixProfileArgs
import com.pulumi.aws.transfer.kotlin.inputs.AccessPosixProfileArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a AWS Transfer Access resource.
 * > **NOTE:** We suggest using explicit JSON encoding or `aws.iam.getPolicyDocument` when assigning a value to `policy`. They seamlessly translate configuration to JSON, enabling you to maintain consistency within your configuration without the need for context switches. Also, you can sidestep potential complications arising from formatting discrepancies, whitespace inconsistencies, and other nuances inherent to JSON.
 * ## Example Usage
 * ### Basic S3
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.transfer.Access("example", {
 *     externalId: "S-1-1-12-1234567890-123456789-1234567890-1234",
 *     serverId: exampleAwsTransferServer.id,
 *     role: exampleAwsIamRole.arn,
 *     homeDirectory: `/${exampleAwsS3Bucket.id}/`,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.transfer.Access("example",
 *     external_id="S-1-1-12-1234567890-123456789-1234567890-1234",
 *     server_id=example_aws_transfer_server["id"],
 *     role=example_aws_iam_role["arn"],
 *     home_directory=f"/{example_aws_s3_bucket['id']}/")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Transfer.Access("example", new()
 *     {
 *         ExternalId = "S-1-1-12-1234567890-123456789-1234567890-1234",
 *         ServerId = exampleAwsTransferServer.Id,
 *         Role = exampleAwsIamRole.Arn,
 *         HomeDirectory = $"/{exampleAwsS3Bucket.Id}/",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/transfer"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := transfer.NewAccess(ctx, "example", &transfer.AccessArgs{
 * 			ExternalId:    pulumi.String("S-1-1-12-1234567890-123456789-1234567890-1234"),
 * 			ServerId:      pulumi.Any(exampleAwsTransferServer.Id),
 * 			Role:          pulumi.Any(exampleAwsIamRole.Arn),
 * 			HomeDirectory: pulumi.Sprintf("/%v/", exampleAwsS3Bucket.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.transfer.Access;
 * import com.pulumi.aws.transfer.AccessArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Access("example", AccessArgs.builder()
 *             .externalId("S-1-1-12-1234567890-123456789-1234567890-1234")
 *             .serverId(exampleAwsTransferServer.id())
 *             .role(exampleAwsIamRole.arn())
 *             .homeDirectory(String.format("/%s/", exampleAwsS3Bucket.id()))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:transfer:Access
 *     properties:
 *       externalId: S-1-1-12-1234567890-123456789-1234567890-1234
 *       serverId: ${exampleAwsTransferServer.id}
 *       role: ${exampleAwsIamRole.arn}
 *       homeDirectory: /${exampleAwsS3Bucket.id}/
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Basic EFS
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.transfer.Access("test", {
 *     externalId: "S-1-1-12-1234567890-123456789-1234567890-1234",
 *     serverId: testAwsTransferServer.id,
 *     role: testAwsIamRole.arn,
 *     homeDirectory: `/${testAwsEfsFileSystem.id}/`,
 *     posixProfile: {
 *         gid: 1000,
 *         uid: 1000,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.transfer.Access("test",
 *     external_id="S-1-1-12-1234567890-123456789-1234567890-1234",
 *     server_id=test_aws_transfer_server["id"],
 *     role=test_aws_iam_role["arn"],
 *     home_directory=f"/{test_aws_efs_file_system['id']}/",
 *     posix_profile={
 *         "gid": 1000,
 *         "uid": 1000,
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.Transfer.Access("test", new()
 *     {
 *         ExternalId = "S-1-1-12-1234567890-123456789-1234567890-1234",
 *         ServerId = testAwsTransferServer.Id,
 *         Role = testAwsIamRole.Arn,
 *         HomeDirectory = $"/{testAwsEfsFileSystem.Id}/",
 *         PosixProfile = new Aws.Transfer.Inputs.AccessPosixProfileArgs
 *         {
 *             Gid = 1000,
 *             Uid = 1000,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/transfer"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := transfer.NewAccess(ctx, "test", &transfer.AccessArgs{
 * 			ExternalId:    pulumi.String("S-1-1-12-1234567890-123456789-1234567890-1234"),
 * 			ServerId:      pulumi.Any(testAwsTransferServer.Id),
 * 			Role:          pulumi.Any(testAwsIamRole.Arn),
 * 			HomeDirectory: pulumi.Sprintf("/%v/", testAwsEfsFileSystem.Id),
 * 			PosixProfile: &transfer.AccessPosixProfileArgs{
 * 				Gid: pulumi.Int(1000),
 * 				Uid: pulumi.Int(1000),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.transfer.Access;
 * import com.pulumi.aws.transfer.AccessArgs;
 * import com.pulumi.aws.transfer.inputs.AccessPosixProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Access("test", AccessArgs.builder()
 *             .externalId("S-1-1-12-1234567890-123456789-1234567890-1234")
 *             .serverId(testAwsTransferServer.id())
 *             .role(testAwsIamRole.arn())
 *             .homeDirectory(String.format("/%s/", testAwsEfsFileSystem.id()))
 *             .posixProfile(AccessPosixProfileArgs.builder()
 *                 .gid(1000)
 *                 .uid(1000)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:transfer:Access
 *     properties:
 *       externalId: S-1-1-12-1234567890-123456789-1234567890-1234
 *       serverId: ${testAwsTransferServer.id}
 *       role: ${testAwsIamRole.arn}
 *       homeDirectory: /${testAwsEfsFileSystem.id}/
 *       posixProfile:
 *         gid: 1000
 *         uid: 1000
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Transfer Accesses using the `server_id` and `external_id`. For example:
 * ```sh
 * $ pulumi import aws:transfer/access:Access example s-12345678/S-1-1-12-1234567890-123456789-1234567890-1234
 * ```
 * @property externalId The SID of a group in the directory connected to the Transfer Server (e.g., `S-1-1-12-1234567890-123456789-1234567890-1234`)
 * @property homeDirectory The landing directory (folder) for a user when they log in to the server using their SFTP client.  It should begin with a `/`.  The first item in the path is the name of the home bucket (accessible as `${Transfer:HomeBucket}` in the policy) and the rest is the home directory (accessible as `${Transfer:HomeDirectory}` in the policy). For example, `/example-bucket-1234/username` would set the home bucket to `example-bucket-1234` and the home directory to `username`.
 * @property homeDirectoryMappings Logical directory mappings that specify what S3 paths and keys should be visible to your user and how you want to make them visible. See Home Directory Mappings below.
 * @property homeDirectoryType The type of landing directory (folder) you mapped for your users' home directory. Valid values are `PATH` and `LOGICAL`.
 * @property policy An IAM JSON policy document that scopes down user access to portions of their Amazon S3 bucket. IAM variables you can use inside this policy include `${Transfer:UserName}`, `${Transfer:HomeDirectory}`, and `${Transfer:HomeBucket}`. These are evaluated on-the-fly when navigating the bucket.
 * @property posixProfile Specifies the full POSIX identity, including user ID (Uid), group ID (Gid), and any secondary groups IDs (SecondaryGids), that controls your users' access to your Amazon EFS file systems. See Posix Profile below.
 * @property role Amazon Resource Name (ARN) of an IAM role that allows the service to controls your user’s access to your Amazon S3 bucket.
 * @property serverId The Server ID of the Transfer Server (e.g., `s-12345678`)
 */
public data class AccessArgs(
    public val externalId: Output<String>? = null,
    public val homeDirectory: Output<String>? = null,
    public val homeDirectoryMappings: Output<List<AccessHomeDirectoryMappingArgs>>? = null,
    public val homeDirectoryType: Output<String>? = null,
    public val policy: Output<String>? = null,
    public val posixProfile: Output<AccessPosixProfileArgs>? = null,
    public val role: Output<String>? = null,
    public val serverId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.transfer.AccessArgs> {
    override fun toJava(): com.pulumi.aws.transfer.AccessArgs =
        com.pulumi.aws.transfer.AccessArgs.builder()
            .externalId(externalId?.applyValue({ args0 -> args0 }))
            .homeDirectory(homeDirectory?.applyValue({ args0 -> args0 }))
            .homeDirectoryMappings(
                homeDirectoryMappings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .homeDirectoryType(homeDirectoryType?.applyValue({ args0 -> args0 }))
            .policy(policy?.applyValue({ args0 -> args0 }))
            .posixProfile(posixProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .role(role?.applyValue({ args0 -> args0 }))
            .serverId(serverId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AccessArgs].
 */
@PulumiTagMarker
public class AccessArgsBuilder internal constructor() {
    private var externalId: Output<String>? = null

    private var homeDirectory: Output<String>? = null

    private var homeDirectoryMappings: Output<List<AccessHomeDirectoryMappingArgs>>? = null

    private var homeDirectoryType: Output<String>? = null

    private var policy: Output<String>? = null

    private var posixProfile: Output<AccessPosixProfileArgs>? = null

    private var role: Output<String>? = null

    private var serverId: Output<String>? = null

    /**
     * @param value The SID of a group in the directory connected to the Transfer Server (e.g., `S-1-1-12-1234567890-123456789-1234567890-1234`)
     */
    @JvmName("smuixopdblpugkgx")
    public suspend fun externalId(`value`: Output<String>) {
        this.externalId = value
    }

    /**
     * @param value The landing directory (folder) for a user when they log in to the server using their SFTP client.  It should begin with a `/`.  The first item in the path is the name of the home bucket (accessible as `${Transfer:HomeBucket}` in the policy) and the rest is the home directory (accessible as `${Transfer:HomeDirectory}` in the policy). For example, `/example-bucket-1234/username` would set the home bucket to `example-bucket-1234` and the home directory to `username`.
     */
    @JvmName("gfssifmnhsjuavue")
    public suspend fun homeDirectory(`value`: Output<String>) {
        this.homeDirectory = value
    }

    /**
     * @param value Logical directory mappings that specify what S3 paths and keys should be visible to your user and how you want to make them visible. See Home Directory Mappings below.
     */
    @JvmName("skbamfmwsonuhwdj")
    public suspend fun homeDirectoryMappings(`value`: Output<List<AccessHomeDirectoryMappingArgs>>) {
        this.homeDirectoryMappings = value
    }

    @JvmName("gxihfgjvuxttogys")
    public suspend fun homeDirectoryMappings(vararg values: Output<AccessHomeDirectoryMappingArgs>) {
        this.homeDirectoryMappings = Output.all(values.asList())
    }

    /**
     * @param values Logical directory mappings that specify what S3 paths and keys should be visible to your user and how you want to make them visible. See Home Directory Mappings below.
     */
    @JvmName("benohtengwniggdm")
    public suspend fun homeDirectoryMappings(values: List<Output<AccessHomeDirectoryMappingArgs>>) {
        this.homeDirectoryMappings = Output.all(values)
    }

    /**
     * @param value The type of landing directory (folder) you mapped for your users' home directory. Valid values are `PATH` and `LOGICAL`.
     */
    @JvmName("oohivttpocmlehyx")
    public suspend fun homeDirectoryType(`value`: Output<String>) {
        this.homeDirectoryType = value
    }

    /**
     * @param value An IAM JSON policy document that scopes down user access to portions of their Amazon S3 bucket. IAM variables you can use inside this policy include `${Transfer:UserName}`, `${Transfer:HomeDirectory}`, and `${Transfer:HomeBucket}`. These are evaluated on-the-fly when navigating the bucket.
     */
    @JvmName("wqessfcbgugmmauc")
    public suspend fun policy(`value`: Output<String>) {
        this.policy = value
    }

    /**
     * @param value Specifies the full POSIX identity, including user ID (Uid), group ID (Gid), and any secondary groups IDs (SecondaryGids), that controls your users' access to your Amazon EFS file systems. See Posix Profile below.
     */
    @JvmName("wukuyyjceepeirpl")
    public suspend fun posixProfile(`value`: Output<AccessPosixProfileArgs>) {
        this.posixProfile = value
    }

    /**
     * @param value Amazon Resource Name (ARN) of an IAM role that allows the service to controls your user’s access to your Amazon S3 bucket.
     */
    @JvmName("rmpulrglgstbsrww")
    public suspend fun role(`value`: Output<String>) {
        this.role = value
    }

    /**
     * @param value The Server ID of the Transfer Server (e.g., `s-12345678`)
     */
    @JvmName("rcegwctiudhddbhp")
    public suspend fun serverId(`value`: Output<String>) {
        this.serverId = value
    }

    /**
     * @param value The SID of a group in the directory connected to the Transfer Server (e.g., `S-1-1-12-1234567890-123456789-1234567890-1234`)
     */
    @JvmName("njvslfaeucaevohx")
    public suspend fun externalId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.externalId = mapped
    }

    /**
     * @param value The landing directory (folder) for a user when they log in to the server using their SFTP client.  It should begin with a `/`.  The first item in the path is the name of the home bucket (accessible as `${Transfer:HomeBucket}` in the policy) and the rest is the home directory (accessible as `${Transfer:HomeDirectory}` in the policy). For example, `/example-bucket-1234/username` would set the home bucket to `example-bucket-1234` and the home directory to `username`.
     */
    @JvmName("wwvskixkheryepxs")
    public suspend fun homeDirectory(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.homeDirectory = mapped
    }

    /**
     * @param value Logical directory mappings that specify what S3 paths and keys should be visible to your user and how you want to make them visible. See Home Directory Mappings below.
     */
    @JvmName("lxrsrmwsgbdhtwyh")
    public suspend fun homeDirectoryMappings(`value`: List<AccessHomeDirectoryMappingArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.homeDirectoryMappings = mapped
    }

    /**
     * @param argument Logical directory mappings that specify what S3 paths and keys should be visible to your user and how you want to make them visible. See Home Directory Mappings below.
     */
    @JvmName("eklifbjpvutdffpx")
    public suspend fun homeDirectoryMappings(argument: List<suspend AccessHomeDirectoryMappingArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AccessHomeDirectoryMappingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.homeDirectoryMappings = mapped
    }

    /**
     * @param argument Logical directory mappings that specify what S3 paths and keys should be visible to your user and how you want to make them visible. See Home Directory Mappings below.
     */
    @JvmName("yrfjlbhlvcmplaif")
    public suspend fun homeDirectoryMappings(vararg argument: suspend AccessHomeDirectoryMappingArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AccessHomeDirectoryMappingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.homeDirectoryMappings = mapped
    }

    /**
     * @param argument Logical directory mappings that specify what S3 paths and keys should be visible to your user and how you want to make them visible. See Home Directory Mappings below.
     */
    @JvmName("yjvahyeixdhacmrj")
    public suspend fun homeDirectoryMappings(argument: suspend AccessHomeDirectoryMappingArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AccessHomeDirectoryMappingArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.homeDirectoryMappings = mapped
    }

    /**
     * @param values Logical directory mappings that specify what S3 paths and keys should be visible to your user and how you want to make them visible. See Home Directory Mappings below.
     */
    @JvmName("btqhaxnyjeisfxcs")
    public suspend fun homeDirectoryMappings(vararg values: AccessHomeDirectoryMappingArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.homeDirectoryMappings = mapped
    }

    /**
     * @param value The type of landing directory (folder) you mapped for your users' home directory. Valid values are `PATH` and `LOGICAL`.
     */
    @JvmName("kkrjiglcrlmvtfql")
    public suspend fun homeDirectoryType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.homeDirectoryType = mapped
    }

    /**
     * @param value An IAM JSON policy document that scopes down user access to portions of their Amazon S3 bucket. IAM variables you can use inside this policy include `${Transfer:UserName}`, `${Transfer:HomeDirectory}`, and `${Transfer:HomeBucket}`. These are evaluated on-the-fly when navigating the bucket.
     */
    @JvmName("unmnmwaguymgreyq")
    public suspend fun policy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    /**
     * @param value Specifies the full POSIX identity, including user ID (Uid), group ID (Gid), and any secondary groups IDs (SecondaryGids), that controls your users' access to your Amazon EFS file systems. See Posix Profile below.
     */
    @JvmName("druuqhcajxuhjnpc")
    public suspend fun posixProfile(`value`: AccessPosixProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.posixProfile = mapped
    }

    /**
     * @param argument Specifies the full POSIX identity, including user ID (Uid), group ID (Gid), and any secondary groups IDs (SecondaryGids), that controls your users' access to your Amazon EFS file systems. See Posix Profile below.
     */
    @JvmName("qsvhjsgmgeufjlgs")
    public suspend fun posixProfile(argument: suspend AccessPosixProfileArgsBuilder.() -> Unit) {
        val toBeMapped = AccessPosixProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.posixProfile = mapped
    }

    /**
     * @param value Amazon Resource Name (ARN) of an IAM role that allows the service to controls your user’s access to your Amazon S3 bucket.
     */
    @JvmName("ptmddhpypnjpjpki")
    public suspend fun role(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.role = mapped
    }

    /**
     * @param value The Server ID of the Transfer Server (e.g., `s-12345678`)
     */
    @JvmName("rwrdprwjdokyvopk")
    public suspend fun serverId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverId = mapped
    }

    internal fun build(): AccessArgs = AccessArgs(
        externalId = externalId,
        homeDirectory = homeDirectory,
        homeDirectoryMappings = homeDirectoryMappings,
        homeDirectoryType = homeDirectoryType,
        policy = policy,
        posixProfile = posixProfile,
        role = role,
        serverId = serverId,
    )
}
