@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.transfer.kotlin

import com.pulumi.aws.transfer.AgreementArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a AWS Transfer AS2 Agreement resource.
 * ## Example Usage
 * ### Basic
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.transfer.Agreement("example", {
 *     accessRole: test.arn,
 *     baseDirectory: "/DOC-EXAMPLE-BUCKET/home/mydirectory",
 *     description: "example",
 *     localProfileId: local.profileId,
 *     partnerProfileId: partner.profileId,
 *     serverId: testAwsTransferServer.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.transfer.Agreement("example",
 *     access_role=test["arn"],
 *     base_directory="/DOC-EXAMPLE-BUCKET/home/mydirectory",
 *     description="example",
 *     local_profile_id=local["profileId"],
 *     partner_profile_id=partner["profileId"],
 *     server_id=test_aws_transfer_server["id"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Transfer.Agreement("example", new()
 *     {
 *         AccessRole = test.Arn,
 *         BaseDirectory = "/DOC-EXAMPLE-BUCKET/home/mydirectory",
 *         Description = "example",
 *         LocalProfileId = local.ProfileId,
 *         PartnerProfileId = partner.ProfileId,
 *         ServerId = testAwsTransferServer.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/transfer"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := transfer.NewAgreement(ctx, "example", &transfer.AgreementArgs{
 * 			AccessRole:       pulumi.Any(test.Arn),
 * 			BaseDirectory:    pulumi.String("/DOC-EXAMPLE-BUCKET/home/mydirectory"),
 * 			Description:      pulumi.String("example"),
 * 			LocalProfileId:   pulumi.Any(local.ProfileId),
 * 			PartnerProfileId: pulumi.Any(partner.ProfileId),
 * 			ServerId:         pulumi.Any(testAwsTransferServer.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.transfer.Agreement;
 * import com.pulumi.aws.transfer.AgreementArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Agreement("example", AgreementArgs.builder()
 *             .accessRole(test.arn())
 *             .baseDirectory("/DOC-EXAMPLE-BUCKET/home/mydirectory")
 *             .description("example")
 *             .localProfileId(local.profileId())
 *             .partnerProfileId(partner.profileId())
 *             .serverId(testAwsTransferServer.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:transfer:Agreement
 *     properties:
 *       accessRole: ${test.arn}
 *       baseDirectory: /DOC-EXAMPLE-BUCKET/home/mydirectory
 *       description: example
 *       localProfileId: ${local.profileId}
 *       partnerProfileId: ${partner.profileId}
 *       serverId: ${testAwsTransferServer.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Transfer AS2 Agreement using the `server_id/agreement_id`. For example:
 * ```sh
 * $ pulumi import aws:transfer/agreement:Agreement example s-4221a88afd5f4362a/a-4221a88afd5f4362a
 * ```
 * @property accessRole The IAM Role which provides read and write access to the parent directory of the file location mentioned in the StartFileTransfer request.
 * @property baseDirectory The landing directory for the files transferred by using the AS2 protocol.
 * @property description The Optional description of the transdfer.
 * @property localProfileId The unique identifier for the AS2 local profile.
 * @property partnerProfileId The unique identifier for the AS2 partner profile.
 * @property serverId The unique server identifier for the server instance. This is the specific server the agreement uses.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class AgreementArgs(
    public val accessRole: Output<String>? = null,
    public val baseDirectory: Output<String>? = null,
    public val description: Output<String>? = null,
    public val localProfileId: Output<String>? = null,
    public val partnerProfileId: Output<String>? = null,
    public val serverId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.transfer.AgreementArgs> {
    override fun toJava(): com.pulumi.aws.transfer.AgreementArgs =
        com.pulumi.aws.transfer.AgreementArgs.builder()
            .accessRole(accessRole?.applyValue({ args0 -> args0 }))
            .baseDirectory(baseDirectory?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .localProfileId(localProfileId?.applyValue({ args0 -> args0 }))
            .partnerProfileId(partnerProfileId?.applyValue({ args0 -> args0 }))
            .serverId(serverId?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [AgreementArgs].
 */
@PulumiTagMarker
public class AgreementArgsBuilder internal constructor() {
    private var accessRole: Output<String>? = null

    private var baseDirectory: Output<String>? = null

    private var description: Output<String>? = null

    private var localProfileId: Output<String>? = null

    private var partnerProfileId: Output<String>? = null

    private var serverId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The IAM Role which provides read and write access to the parent directory of the file location mentioned in the StartFileTransfer request.
     */
    @JvmName("fqumvqgytfjepnyy")
    public suspend fun accessRole(`value`: Output<String>) {
        this.accessRole = value
    }

    /**
     * @param value The landing directory for the files transferred by using the AS2 protocol.
     */
    @JvmName("neipaaicigjvtcgj")
    public suspend fun baseDirectory(`value`: Output<String>) {
        this.baseDirectory = value
    }

    /**
     * @param value The Optional description of the transdfer.
     */
    @JvmName("pkkbdmsdwcfiyxuu")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The unique identifier for the AS2 local profile.
     */
    @JvmName("votgyhgoewonyedo")
    public suspend fun localProfileId(`value`: Output<String>) {
        this.localProfileId = value
    }

    /**
     * @param value The unique identifier for the AS2 partner profile.
     */
    @JvmName("hwieyyslqdytpejw")
    public suspend fun partnerProfileId(`value`: Output<String>) {
        this.partnerProfileId = value
    }

    /**
     * @param value The unique server identifier for the server instance. This is the specific server the agreement uses.
     */
    @JvmName("dutsjnallglkmtdc")
    public suspend fun serverId(`value`: Output<String>) {
        this.serverId = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ajktwxoboilwnxkb")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The IAM Role which provides read and write access to the parent directory of the file location mentioned in the StartFileTransfer request.
     */
    @JvmName("hfqdyrgcvyymtekb")
    public suspend fun accessRole(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessRole = mapped
    }

    /**
     * @param value The landing directory for the files transferred by using the AS2 protocol.
     */
    @JvmName("jmyrdkxdfioqwfrm")
    public suspend fun baseDirectory(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.baseDirectory = mapped
    }

    /**
     * @param value The Optional description of the transdfer.
     */
    @JvmName("pcpchiwrtecrbiux")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The unique identifier for the AS2 local profile.
     */
    @JvmName("hfdovnlnrjhakjvu")
    public suspend fun localProfileId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.localProfileId = mapped
    }

    /**
     * @param value The unique identifier for the AS2 partner profile.
     */
    @JvmName("qvlpqywdcbpvlvxl")
    public suspend fun partnerProfileId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partnerProfileId = mapped
    }

    /**
     * @param value The unique server identifier for the server instance. This is the specific server the agreement uses.
     */
    @JvmName("tadbcdkukrjsojld")
    public suspend fun serverId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverId = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("awfexxrsgtsrwcqu")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("keyqgbkqjolwisps")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): AgreementArgs = AgreementArgs(
        accessRole = accessRole,
        baseDirectory = baseDirectory,
        description = description,
        localProfileId = localProfileId,
        partnerProfileId = partnerProfileId,
        serverId = serverId,
        tags = tags,
    )
}
