@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.transfer.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Certificate].
 */
@PulumiTagMarker
public class CertificateResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CertificateArgs = CertificateArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CertificateArgsBuilder.() -> Unit) {
        val builder = CertificateArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Certificate {
        val builtJavaResource = com.pulumi.aws.transfer.Certificate(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Certificate(builtJavaResource)
    }
}

/**
 * Provides a AWS Transfer AS2 Certificate resource.
 * ## Example Usage
 * ## Import
 * Using `pulumi import`, import Transfer AS2 Certificate using the `certificate_id`. For example:
 * ```sh
 * $ pulumi import aws:transfer/certificate:Certificate example c-4221a88afd5f4362a
 * ```
 */
public class Certificate internal constructor(
    override val javaResource: com.pulumi.aws.transfer.Certificate,
) : KotlinCustomResource(javaResource, CertificateMapper) {
    /**
     * An date when the certificate becomes active
     */
    public val activeDate: Output<String>
        get() = javaResource.activeDate().applyValue({ args0 -> args0 })

    /**
     * The ARN of the certificate
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The valid certificate file required for the transfer.
     */
    public val certificate: Output<String>
        get() = javaResource.certificate().applyValue({ args0 -> args0 })

    /**
     * The optional list of certificate that make up the chain for the certificate that is being imported.
     */
    public val certificateChain: Output<String>?
        get() = javaResource.certificateChain().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The unique identifier for the AS2 certificate
     */
    public val certificateId: Output<String>
        get() = javaResource.certificateId().applyValue({ args0 -> args0 })

    /**
     * A short description that helps identify the certificate.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * An date when the certificate becomes inactive
     */
    public val inactiveDate: Output<String>
        get() = javaResource.inactiveDate().applyValue({ args0 -> args0 })

    /**
     * The private key associated with the certificate being imported.
     */
    public val privateKey: Output<String>?
        get() = javaResource.privateKey().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Specifies if a certificate is being used for signing or encryption. The valid values are SIGNING and ENCRYPTION.
     */
    public val usage: Output<String>
        get() = javaResource.usage().applyValue({ args0 -> args0 })
}

public object CertificateMapper : ResourceMapper<Certificate> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.transfer.Certificate::class == javaResource::class

    override fun map(javaResource: Resource): Certificate = Certificate(
        javaResource as
            com.pulumi.aws.transfer.Certificate,
    )
}

/**
 * @see [Certificate].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Certificate].
 */
public suspend fun certificate(name: String, block: suspend CertificateResourceBuilder.() -> Unit): Certificate {
    val builder = CertificateResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Certificate].
 * @param name The _unique_ name of the resulting resource.
 */
public fun certificate(name: String): Certificate {
    val builder = CertificateResourceBuilder()
    builder.name(name)
    return builder.build()
}
