@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.transfer.kotlin

import com.pulumi.aws.transfer.kotlin.outputs.ConnectorAs2Config
import com.pulumi.aws.transfer.kotlin.outputs.ConnectorSftpConfig
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.transfer.kotlin.outputs.ConnectorAs2Config.Companion.toKotlin as connectorAs2ConfigToKotlin
import com.pulumi.aws.transfer.kotlin.outputs.ConnectorSftpConfig.Companion.toKotlin as connectorSftpConfigToKotlin

/**
 * Builder for [Connector].
 */
@PulumiTagMarker
public class ConnectorResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ConnectorArgs = ConnectorArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ConnectorArgsBuilder.() -> Unit) {
        val builder = ConnectorArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Connector {
        val builtJavaResource = com.pulumi.aws.transfer.Connector(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Connector(builtJavaResource)
    }
}

/**
 * Provides a AWS Transfer AS2 Connector resource.
 * ## Example Usage
 * ### Basic
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.transfer.Connector("example", {
 *     accessRole: test.arn,
 *     as2Config: {
 *         compression: "DISABLED",
 *         encryptionAlgorithm: "AWS128_CBC",
 *         messageSubject: "For Connector",
 *         localProfileId: local.profileId,
 *         mdnResponse: "NONE",
 *         mdnSigningAlgorithm: "NONE",
 *         partnerProfileId: partner.profileId,
 *         signingAlgorithm: "NONE",
 *     },
 *     url: "http://www.test.com",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.transfer.Connector("example",
 *     access_role=test["arn"],
 *     as2_config={
 *         "compression": "DISABLED",
 *         "encryption_algorithm": "AWS128_CBC",
 *         "message_subject": "For Connector",
 *         "local_profile_id": local["profileId"],
 *         "mdn_response": "NONE",
 *         "mdn_signing_algorithm": "NONE",
 *         "partner_profile_id": partner["profileId"],
 *         "signing_algorithm": "NONE",
 *     },
 *     url="http://www.test.com")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Transfer.Connector("example", new()
 *     {
 *         AccessRole = test.Arn,
 *         As2Config = new Aws.Transfer.Inputs.ConnectorAs2ConfigArgs
 *         {
 *             Compression = "DISABLED",
 *             EncryptionAlgorithm = "AWS128_CBC",
 *             MessageSubject = "For Connector",
 *             LocalProfileId = local.ProfileId,
 *             MdnResponse = "NONE",
 *             MdnSigningAlgorithm = "NONE",
 *             PartnerProfileId = partner.ProfileId,
 *             SigningAlgorithm = "NONE",
 *         },
 *         Url = "http://www.test.com",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/transfer"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := transfer.NewConnector(ctx, "example", &transfer.ConnectorArgs{
 * 			AccessRole: pulumi.Any(test.Arn),
 * 			As2Config: &transfer.ConnectorAs2ConfigArgs{
 * 				Compression:         pulumi.String("DISABLED"),
 * 				EncryptionAlgorithm: pulumi.String("AWS128_CBC"),
 * 				MessageSubject:      pulumi.String("For Connector"),
 * 				LocalProfileId:      pulumi.Any(local.ProfileId),
 * 				MdnResponse:         pulumi.String("NONE"),
 * 				MdnSigningAlgorithm: pulumi.String("NONE"),
 * 				PartnerProfileId:    pulumi.Any(partner.ProfileId),
 * 				SigningAlgorithm:    pulumi.String("NONE"),
 * 			},
 * 			Url: pulumi.String("http://www.test.com"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.transfer.Connector;
 * import com.pulumi.aws.transfer.ConnectorArgs;
 * import com.pulumi.aws.transfer.inputs.ConnectorAs2ConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Connector("example", ConnectorArgs.builder()
 *             .accessRole(test.arn())
 *             .as2Config(ConnectorAs2ConfigArgs.builder()
 *                 .compression("DISABLED")
 *                 .encryptionAlgorithm("AWS128_CBC")
 *                 .messageSubject("For Connector")
 *                 .localProfileId(local.profileId())
 *                 .mdnResponse("NONE")
 *                 .mdnSigningAlgorithm("NONE")
 *                 .partnerProfileId(partner.profileId())
 *                 .signingAlgorithm("NONE")
 *                 .build())
 *             .url("http://www.test.com")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:transfer:Connector
 *     properties:
 *       accessRole: ${test.arn}
 *       as2Config:
 *         compression: DISABLED
 *         encryptionAlgorithm: AWS128_CBC
 *         messageSubject: For Connector
 *         localProfileId: ${local.profileId}
 *         mdnResponse: NONE
 *         mdnSigningAlgorithm: NONE
 *         partnerProfileId: ${partner.profileId}
 *         signingAlgorithm: NONE
 *       url: http://www.test.com
 * ```
 * <!--End PulumiCodeChooser -->
 * ### SFTP Connector
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.transfer.Connector("example", {
 *     accessRole: test.arn,
 *     sftpConfig: {
 *         trustedHostKeys: ["ssh-rsa AAAAB3NYourKeysHere"],
 *         userSecretId: exampleAwsSecretsmanagerSecret.id,
 *     },
 *     url: "sftp://test.com",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.transfer.Connector("example",
 *     access_role=test["arn"],
 *     sftp_config={
 *         "trusted_host_keys": ["ssh-rsa AAAAB3NYourKeysHere"],
 *         "user_secret_id": example_aws_secretsmanager_secret["id"],
 *     },
 *     url="sftp://test.com")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Transfer.Connector("example", new()
 *     {
 *         AccessRole = test.Arn,
 *         SftpConfig = new Aws.Transfer.Inputs.ConnectorSftpConfigArgs
 *         {
 *             TrustedHostKeys = new[]
 *             {
 *                 "ssh-rsa AAAAB3NYourKeysHere",
 *             },
 *             UserSecretId = exampleAwsSecretsmanagerSecret.Id,
 *         },
 *         Url = "sftp://test.com",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/transfer"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := transfer.NewConnector(ctx, "example", &transfer.ConnectorArgs{
 * 			AccessRole: pulumi.Any(test.Arn),
 * 			SftpConfig: &transfer.ConnectorSftpConfigArgs{
 * 				TrustedHostKeys: pulumi.StringArray{
 * 					pulumi.String("ssh-rsa AAAAB3NYourKeysHere"),
 * 				},
 * 				UserSecretId: pulumi.Any(exampleAwsSecretsmanagerSecret.Id),
 * 			},
 * 			Url: pulumi.String("sftp://test.com"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.transfer.Connector;
 * import com.pulumi.aws.transfer.ConnectorArgs;
 * import com.pulumi.aws.transfer.inputs.ConnectorSftpConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Connector("example", ConnectorArgs.builder()
 *             .accessRole(test.arn())
 *             .sftpConfig(ConnectorSftpConfigArgs.builder()
 *                 .trustedHostKeys("ssh-rsa AAAAB3NYourKeysHere")
 *                 .userSecretId(exampleAwsSecretsmanagerSecret.id())
 *                 .build())
 *             .url("sftp://test.com")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:transfer:Connector
 *     properties:
 *       accessRole: ${test.arn}
 *       sftpConfig:
 *         trustedHostKeys:
 *           - ssh-rsa AAAAB3NYourKeysHere
 *         userSecretId: ${exampleAwsSecretsmanagerSecret.id}
 *       url: sftp://test.com
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Transfer AS2 Connector using the `connector_id`. For example:
 * ```sh
 * $ pulumi import aws:transfer/connector:Connector example c-4221a88afd5f4362a
 * ```
 */
public class Connector internal constructor(
    override val javaResource: com.pulumi.aws.transfer.Connector,
) : KotlinCustomResource(javaResource, ConnectorMapper) {
    /**
     * The IAM Role which provides read and write access to the parent directory of the file location mentioned in the StartFileTransfer request.
     */
    public val accessRole: Output<String>
        get() = javaResource.accessRole().applyValue({ args0 -> args0 })

    /**
     * The ARN of the connector.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Either SFTP or AS2 is configured.The parameters to configure for the connector object. Fields documented below.
     */
    public val as2Config: Output<ConnectorAs2Config>?
        get() = javaResource.as2Config().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    connectorAs2ConfigToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The unique identifier for the AS2 profile or SFTP Profile.
     */
    public val connectorId: Output<String>
        get() = javaResource.connectorId().applyValue({ args0 -> args0 })

    /**
     * The IAM Role which is required for allowing the connector to turn on CloudWatch logging for Amazon S3 events.
     */
    public val loggingRole: Output<String>?
        get() = javaResource.loggingRole().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Name of the security policy for the connector.
     */
    public val securityPolicyName: Output<String>
        get() = javaResource.securityPolicyName().applyValue({ args0 -> args0 })

    /**
     * Either SFTP or AS2 is configured.The parameters to configure for the connector object. Fields documented below.
     */
    public val sftpConfig: Output<ConnectorSftpConfig>?
        get() = javaResource.sftpConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    connectorSftpConfigToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The URL of the partners AS2 endpoint or SFTP endpoint.
     */
    public val url: Output<String>
        get() = javaResource.url().applyValue({ args0 -> args0 })
}

public object ConnectorMapper : ResourceMapper<Connector> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.transfer.Connector::class == javaResource::class

    override fun map(javaResource: Resource): Connector = Connector(
        javaResource as
            com.pulumi.aws.transfer.Connector,
    )
}

/**
 * @see [Connector].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Connector].
 */
public suspend fun connector(name: String, block: suspend ConnectorResourceBuilder.() -> Unit): Connector {
    val builder = ConnectorResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Connector].
 * @param name The _unique_ name of the resulting resource.
 */
public fun connector(name: String): Connector {
    val builder = ConnectorResourceBuilder()
    builder.name(name)
    return builder.build()
}
