@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.transfer.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [Profile].
 */
@PulumiTagMarker
public class ProfileResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ProfileArgs = ProfileArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ProfileArgsBuilder.() -> Unit) {
        val builder = ProfileArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Profile {
        val builtJavaResource = com.pulumi.aws.transfer.Profile(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Profile(builtJavaResource)
    }
}

/**
 * Provides a AWS Transfer AS2 Profile resource.
 * ## Example Usage
 * ### Basic
 * <!--Start PulumiCodeChooser -->
 * ```yaml
 * resources:
 *   example:
 *     type: aws:transfer:Profile
 *     properties:
 *       as2Id: example
 *       certificateIds:
 *         - ${exampleAwsTransferCertificate.certificateId}
 *       usage: LOCAL
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Transfer AS2 Profile using the `profile_id`. For example:
 * ```sh
 * $ pulumi import aws:transfer/profile:Profile example p-4221a88afd5f4362a
 * ```
 */
public class Profile internal constructor(
    override val javaResource: com.pulumi.aws.transfer.Profile,
) : KotlinCustomResource(javaResource, ProfileMapper) {
    /**
     * The ARN of the profile.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The As2Id is the AS2 name as defined in the RFC 4130. For inbound ttransfers this is the AS2 From Header for the AS2 messages sent from the partner. For Outbound messages this is the AS2 To Header for the AS2 messages sent to the partner. his ID cannot include spaces.
     */
    public val as2Id: Output<String>
        get() = javaResource.as2Id().applyValue({ args0 -> args0 })

    /**
     * The list of certificate Ids from the imported certificate operation.
     */
    public val certificateIds: Output<List<String>>?
        get() = javaResource.certificateIds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The unique identifier for the AS2 profile.
     */
    public val profileId: Output<String>
        get() = javaResource.profileId().applyValue({ args0 -> args0 })

    /**
     * The profile type should be LOCAL or PARTNER.
     */
    public val profileType: Output<String>
        get() = javaResource.profileType().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object ProfileMapper : ResourceMapper<Profile> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.transfer.Profile::class == javaResource::class

    override fun map(javaResource: Resource): Profile = Profile(
        javaResource as
            com.pulumi.aws.transfer.Profile,
    )
}

/**
 * @see [Profile].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Profile].
 */
public suspend fun profile(name: String, block: suspend ProfileResourceBuilder.() -> Unit): Profile {
    val builder = ProfileResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Profile].
 * @param name The _unique_ name of the resulting resource.
 */
public fun profile(name: String): Profile {
    val builder = ProfileResourceBuilder()
    builder.name(name)
    return builder.build()
}
