@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.transfer.kotlin

import com.pulumi.aws.transfer.TransferFunctions.getConnectorPlain
import com.pulumi.aws.transfer.TransferFunctions.getServerPlain
import com.pulumi.aws.transfer.kotlin.inputs.GetConnectorPlainArgs
import com.pulumi.aws.transfer.kotlin.inputs.GetConnectorPlainArgsBuilder
import com.pulumi.aws.transfer.kotlin.inputs.GetServerPlainArgs
import com.pulumi.aws.transfer.kotlin.inputs.GetServerPlainArgsBuilder
import com.pulumi.aws.transfer.kotlin.outputs.GetConnectorResult
import com.pulumi.aws.transfer.kotlin.outputs.GetServerResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.aws.transfer.kotlin.outputs.GetConnectorResult.Companion.toKotlin as getConnectorResultToKotlin
import com.pulumi.aws.transfer.kotlin.outputs.GetServerResult.Companion.toKotlin as getServerResultToKotlin

public object TransferFunctions {
    /**
     * Data source for managing an AWS Transfer Family Connector.
     * @param argument A collection of arguments for invoking getConnector.
     * @return A collection of values returned by getConnector.
     */
    public suspend fun getConnector(argument: GetConnectorPlainArgs): GetConnectorResult =
        getConnectorResultToKotlin(getConnectorPlain(argument.toJava()).await())

    /**
     * @see [getConnector].
     * @param id Unique identifier for connector
     * @return A collection of values returned by getConnector.
     */
    public suspend fun getConnector(id: String): GetConnectorResult {
        val argument = GetConnectorPlainArgs(
            id = id,
        )
        return getConnectorResultToKotlin(getConnectorPlain(argument.toJava()).await())
    }

    /**
     * @see [getConnector].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;transfer&#46;kotlin&#46;inputs&#46;GetConnectorPlainArgs].
     * @return A collection of values returned by getConnector.
     */
    public suspend fun getConnector(argument: suspend GetConnectorPlainArgsBuilder.() -> Unit): GetConnectorResult {
        val builder = GetConnectorPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getConnectorResultToKotlin(getConnectorPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get the ARN of an AWS Transfer Server for use in other
     * resources.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.transfer.getServer({
     *     serverId: "s-1234567",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.transfer.get_server(server_id="s-1234567")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Transfer.GetServer.Invoke(new()
     *     {
     *         ServerId = "s-1234567",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/transfer"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := transfer.LookupServer(ctx, &transfer.LookupServerArgs{
     * 			ServerId: "s-1234567",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.transfer.TransferFunctions;
     * import com.pulumi.aws.transfer.inputs.GetServerArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = TransferFunctions.getServer(GetServerArgs.builder()
     *             .serverId("s-1234567")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:transfer:getServer
     *       Arguments:
     *         serverId: s-1234567
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getServer.
     * @return A collection of values returned by getServer.
     */
    public suspend fun getServer(argument: GetServerPlainArgs): GetServerResult =
        getServerResultToKotlin(getServerPlain(argument.toJava()).await())

    /**
     * @see [getServer].
     * @param serverId ID for an SFTP server.
     * @return A collection of values returned by getServer.
     */
    public suspend fun getServer(serverId: String): GetServerResult {
        val argument = GetServerPlainArgs(
            serverId = serverId,
        )
        return getServerResultToKotlin(getServerPlain(argument.toJava()).await())
    }

    /**
     * @see [getServer].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;transfer&#46;kotlin&#46;inputs&#46;GetServerPlainArgs].
     * @return A collection of values returned by getServer.
     */
    public suspend fun getServer(argument: suspend GetServerPlainArgsBuilder.() -> Unit): GetServerResult {
        val builder = GetServerPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServerResultToKotlin(getServerPlain(builtArgument.toJava()).await())
    }
}
