@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.transfer.kotlin

import com.pulumi.aws.transfer.WorkflowArgs.builder
import com.pulumi.aws.transfer.kotlin.inputs.WorkflowOnExceptionStepArgs
import com.pulumi.aws.transfer.kotlin.inputs.WorkflowOnExceptionStepArgsBuilder
import com.pulumi.aws.transfer.kotlin.inputs.WorkflowStepArgs
import com.pulumi.aws.transfer.kotlin.inputs.WorkflowStepArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a AWS Transfer Workflow resource.
 * ## Example Usage
 * ### Basic single step example
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.transfer.Workflow("example", {steps: [{
 *     deleteStepDetails: {
 *         name: "example",
 *         sourceFileLocation: "${original.file}",
 *     },
 *     type: "DELETE",
 * }]});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.transfer.Workflow("example", steps=[{
 *     "delete_step_details": {
 *         "name": "example",
 *         "source_file_location": "${original.file}",
 *     },
 *     "type": "DELETE",
 * }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Transfer.Workflow("example", new()
 *     {
 *         Steps = new[]
 *         {
 *             new Aws.Transfer.Inputs.WorkflowStepArgs
 *             {
 *                 DeleteStepDetails = new Aws.Transfer.Inputs.WorkflowStepDeleteStepDetailsArgs
 *                 {
 *                     Name = "example",
 *                     SourceFileLocation = "${original.file}",
 *                 },
 *                 Type = "DELETE",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/transfer"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := transfer.NewWorkflow(ctx, "example", &transfer.WorkflowArgs{
 * 			Steps: transfer.WorkflowStepArray{
 * 				&transfer.WorkflowStepArgs{
 * 					DeleteStepDetails: &transfer.WorkflowStepDeleteStepDetailsArgs{
 * 						Name:               pulumi.String("example"),
 * 						SourceFileLocation: pulumi.String("${original.file}"),
 * 					},
 * 					Type: pulumi.String("DELETE"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.transfer.Workflow;
 * import com.pulumi.aws.transfer.WorkflowArgs;
 * import com.pulumi.aws.transfer.inputs.WorkflowStepArgs;
 * import com.pulumi.aws.transfer.inputs.WorkflowStepDeleteStepDetailsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Workflow("example", WorkflowArgs.builder()
 *             .steps(WorkflowStepArgs.builder()
 *                 .deleteStepDetails(WorkflowStepDeleteStepDetailsArgs.builder()
 *                     .name("example")
 *                     .sourceFileLocation("${original.file}")
 *                     .build())
 *                 .type("DELETE")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:transfer:Workflow
 *     properties:
 *       steps:
 *         - deleteStepDetails:
 *             name: example
 *             sourceFileLocation: ${original.file}
 *           type: DELETE
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Multistep example
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.transfer.Workflow("example", {steps: [
 *     {
 *         customStepDetails: {
 *             name: "example",
 *             sourceFileLocation: "${original.file}",
 *             target: exampleAwsLambdaFunction.arn,
 *             timeoutSeconds: 60,
 *         },
 *         type: "CUSTOM",
 *     },
 *     {
 *         tagStepDetails: {
 *             name: "example",
 *             sourceFileLocation: "${original.file}",
 *             tags: [{
 *                 key: "Name",
 *                 value: "Hello World",
 *             }],
 *         },
 *         type: "TAG",
 *     },
 * ]});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.transfer.Workflow("example", steps=[
 *     {
 *         "custom_step_details": {
 *             "name": "example",
 *             "source_file_location": "${original.file}",
 *             "target": example_aws_lambda_function["arn"],
 *             "timeout_seconds": 60,
 *         },
 *         "type": "CUSTOM",
 *     },
 *     {
 *         "tag_step_details": {
 *             "name": "example",
 *             "source_file_location": "${original.file}",
 *             "tags": [{
 *                 "key": "Name",
 *                 "value": "Hello World",
 *             }],
 *         },
 *         "type": "TAG",
 *     },
 * ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Transfer.Workflow("example", new()
 *     {
 *         Steps = new[]
 *         {
 *             new Aws.Transfer.Inputs.WorkflowStepArgs
 *             {
 *                 CustomStepDetails = new Aws.Transfer.Inputs.WorkflowStepCustomStepDetailsArgs
 *                 {
 *                     Name = "example",
 *                     SourceFileLocation = "${original.file}",
 *                     Target = exampleAwsLambdaFunction.Arn,
 *                     TimeoutSeconds = 60,
 *                 },
 *                 Type = "CUSTOM",
 *             },
 *             new Aws.Transfer.Inputs.WorkflowStepArgs
 *             {
 *                 TagStepDetails = new Aws.Transfer.Inputs.WorkflowStepTagStepDetailsArgs
 *                 {
 *                     Name = "example",
 *                     SourceFileLocation = "${original.file}",
 *                     Tags = new[]
 *                     {
 *                         new Aws.Transfer.Inputs.WorkflowStepTagStepDetailsTagArgs
 *                         {
 *                             Key = "Name",
 *                             Value = "Hello World",
 *                         },
 *                     },
 *                 },
 *                 Type = "TAG",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/transfer"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := transfer.NewWorkflow(ctx, "example", &transfer.WorkflowArgs{
 * 			Steps: transfer.WorkflowStepArray{
 * 				&transfer.WorkflowStepArgs{
 * 					CustomStepDetails: &transfer.WorkflowStepCustomStepDetailsArgs{
 * 						Name:               pulumi.String("example"),
 * 						SourceFileLocation: pulumi.String("${original.file}"),
 * 						Target:             pulumi.Any(exampleAwsLambdaFunction.Arn),
 * 						TimeoutSeconds:     pulumi.Int(60),
 * 					},
 * 					Type: pulumi.String("CUSTOM"),
 * 				},
 * 				&transfer.WorkflowStepArgs{
 * 					TagStepDetails: &transfer.WorkflowStepTagStepDetailsArgs{
 * 						Name:               pulumi.String("example"),
 * 						SourceFileLocation: pulumi.String("${original.file}"),
 * 						Tags: transfer.WorkflowStepTagStepDetailsTagArray{
 * 							&transfer.WorkflowStepTagStepDetailsTagArgs{
 * 								Key:   pulumi.String("Name"),
 * 								Value: pulumi.String("Hello World"),
 * 							},
 * 						},
 * 					},
 * 					Type: pulumi.String("TAG"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.transfer.Workflow;
 * import com.pulumi.aws.transfer.WorkflowArgs;
 * import com.pulumi.aws.transfer.inputs.WorkflowStepArgs;
 * import com.pulumi.aws.transfer.inputs.WorkflowStepCustomStepDetailsArgs;
 * import com.pulumi.aws.transfer.inputs.WorkflowStepTagStepDetailsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Workflow("example", WorkflowArgs.builder()
 *             .steps(
 *                 WorkflowStepArgs.builder()
 *                     .customStepDetails(WorkflowStepCustomStepDetailsArgs.builder()
 *                         .name("example")
 *                         .sourceFileLocation("${original.file}")
 *                         .target(exampleAwsLambdaFunction.arn())
 *                         .timeoutSeconds(60)
 *                         .build())
 *                     .type("CUSTOM")
 *                     .build(),
 *                 WorkflowStepArgs.builder()
 *                     .tagStepDetails(WorkflowStepTagStepDetailsArgs.builder()
 *                         .name("example")
 *                         .sourceFileLocation("${original.file}")
 *                         .tags(WorkflowStepTagStepDetailsTagArgs.builder()
 *                             .key("Name")
 *                             .value("Hello World")
 *                             .build())
 *                         .build())
 *                     .type("TAG")
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:transfer:Workflow
 *     properties:
 *       steps:
 *         - customStepDetails:
 *             name: example
 *             sourceFileLocation: ${original.file}
 *             target: ${exampleAwsLambdaFunction.arn}
 *             timeoutSeconds: 60
 *           type: CUSTOM
 *         - tagStepDetails:
 *             name: example
 *             sourceFileLocation: ${original.file}
 *             tags:
 *               - key: Name
 *                 value: Hello World
 *           type: TAG
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Transfer Workflows using the `worflow_id`. For example:
 * ```sh
 * $ pulumi import aws:transfer/workflow:Workflow example example
 * ```
 * @property description A textual description for the workflow.
 * @property onExceptionSteps Specifies the steps (actions) to take if errors are encountered during execution of the workflow. See Workflow Steps below.
 * @property steps Specifies the details for the steps that are in the specified workflow. See Workflow Steps below.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class WorkflowArgs(
    public val description: Output<String>? = null,
    public val onExceptionSteps: Output<List<WorkflowOnExceptionStepArgs>>? = null,
    public val steps: Output<List<WorkflowStepArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.transfer.WorkflowArgs> {
    override fun toJava(): com.pulumi.aws.transfer.WorkflowArgs =
        com.pulumi.aws.transfer.WorkflowArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .onExceptionSteps(
                onExceptionSteps?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .steps(steps?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [WorkflowArgs].
 */
@PulumiTagMarker
public class WorkflowArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var onExceptionSteps: Output<List<WorkflowOnExceptionStepArgs>>? = null

    private var steps: Output<List<WorkflowStepArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value A textual description for the workflow.
     */
    @JvmName("lkgkstfvgqseuspq")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Specifies the steps (actions) to take if errors are encountered during execution of the workflow. See Workflow Steps below.
     */
    @JvmName("tunnlytqnihmqnuq")
    public suspend fun onExceptionSteps(`value`: Output<List<WorkflowOnExceptionStepArgs>>) {
        this.onExceptionSteps = value
    }

    @JvmName("cntycixmdkwudxrh")
    public suspend fun onExceptionSteps(vararg values: Output<WorkflowOnExceptionStepArgs>) {
        this.onExceptionSteps = Output.all(values.asList())
    }

    /**
     * @param values Specifies the steps (actions) to take if errors are encountered during execution of the workflow. See Workflow Steps below.
     */
    @JvmName("dwkepjvarqnkxjrp")
    public suspend fun onExceptionSteps(values: List<Output<WorkflowOnExceptionStepArgs>>) {
        this.onExceptionSteps = Output.all(values)
    }

    /**
     * @param value Specifies the details for the steps that are in the specified workflow. See Workflow Steps below.
     */
    @JvmName("xqtaeaeevfxvvytd")
    public suspend fun steps(`value`: Output<List<WorkflowStepArgs>>) {
        this.steps = value
    }

    @JvmName("pbbixegnxrbtuucl")
    public suspend fun steps(vararg values: Output<WorkflowStepArgs>) {
        this.steps = Output.all(values.asList())
    }

    /**
     * @param values Specifies the details for the steps that are in the specified workflow. See Workflow Steps below.
     */
    @JvmName("ovycpdprprcvamwp")
    public suspend fun steps(values: List<Output<WorkflowStepArgs>>) {
        this.steps = Output.all(values)
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("vqnoelpnfucboqvh")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A textual description for the workflow.
     */
    @JvmName("iisjqbqjkfhgdrev")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Specifies the steps (actions) to take if errors are encountered during execution of the workflow. See Workflow Steps below.
     */
    @JvmName("yhylsdmfplhytadi")
    public suspend fun onExceptionSteps(`value`: List<WorkflowOnExceptionStepArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onExceptionSteps = mapped
    }

    /**
     * @param argument Specifies the steps (actions) to take if errors are encountered during execution of the workflow. See Workflow Steps below.
     */
    @JvmName("bkoeydukoerqrsei")
    public suspend fun onExceptionSteps(argument: List<suspend WorkflowOnExceptionStepArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WorkflowOnExceptionStepArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.onExceptionSteps = mapped
    }

    /**
     * @param argument Specifies the steps (actions) to take if errors are encountered during execution of the workflow. See Workflow Steps below.
     */
    @JvmName("hpodeejgnisxjmhy")
    public suspend fun onExceptionSteps(vararg argument: suspend WorkflowOnExceptionStepArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            WorkflowOnExceptionStepArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.onExceptionSteps = mapped
    }

    /**
     * @param argument Specifies the steps (actions) to take if errors are encountered during execution of the workflow. See Workflow Steps below.
     */
    @JvmName("tjjdykfusvvkjpsg")
    public suspend fun onExceptionSteps(argument: suspend WorkflowOnExceptionStepArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            WorkflowOnExceptionStepArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.onExceptionSteps = mapped
    }

    /**
     * @param values Specifies the steps (actions) to take if errors are encountered during execution of the workflow. See Workflow Steps below.
     */
    @JvmName("jjmvisjylnuiqyna")
    public suspend fun onExceptionSteps(vararg values: WorkflowOnExceptionStepArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.onExceptionSteps = mapped
    }

    /**
     * @param value Specifies the details for the steps that are in the specified workflow. See Workflow Steps below.
     */
    @JvmName("dotucloyvqqklunu")
    public suspend fun steps(`value`: List<WorkflowStepArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.steps = mapped
    }

    /**
     * @param argument Specifies the details for the steps that are in the specified workflow. See Workflow Steps below.
     */
    @JvmName("ktnkpgtcfatqdinl")
    public suspend fun steps(argument: List<suspend WorkflowStepArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WorkflowStepArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.steps = mapped
    }

    /**
     * @param argument Specifies the details for the steps that are in the specified workflow. See Workflow Steps below.
     */
    @JvmName("ukrcjmjpcvlpixvf")
    public suspend fun steps(vararg argument: suspend WorkflowStepArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            WorkflowStepArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.steps = mapped
    }

    /**
     * @param argument Specifies the details for the steps that are in the specified workflow. See Workflow Steps below.
     */
    @JvmName("tlreamvvqmcosnvt")
    public suspend fun steps(argument: suspend WorkflowStepArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(WorkflowStepArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.steps = mapped
    }

    /**
     * @param values Specifies the details for the steps that are in the specified workflow. See Workflow Steps below.
     */
    @JvmName("kdkmfxdbrlqitvdm")
    public suspend fun steps(vararg values: WorkflowStepArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.steps = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("haipedxngqcqwlyp")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("sitagohrksyyngxq")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): WorkflowArgs = WorkflowArgs(
        description = description,
        onExceptionSteps = onExceptionSteps,
        steps = steps,
        tags = tags,
    )
}
