@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.transfer.kotlin.inputs

import com.pulumi.aws.transfer.inputs.ConnectorAs2ConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property compression Specifies weather AS2 file is compressed. The valud values are ZLIB and  DISABLED.
 * @property encryptionAlgorithm The algorithm that is used to encrypt the file. The valid values are AES128_CBC | AES192_CBC | AES256_CBC | NONE.
 * @property localProfileId The unique identifier for the AS2 local profile.
 * @property mdnResponse Used for outbound requests to determine if a partner response for transfers is synchronous or asynchronous. The valid values are SYNC and NONE.
 * @property mdnSigningAlgorithm The signing algorithm for the Mdn response. The valid values are SHA256 | SHA384 | SHA512 | SHA1 | NONE | DEFAULT.
 * @property messageSubject Used as the subject HTTP header attribute in AS2 messages that are being sent with the connector.
 * @property partnerProfileId The unique identifier for the AS2 partner profile.
 * @property signingAlgorithm The algorithm that is used to sign AS2 messages sent with the connector. The valid values are SHA256 | SHA384 | SHA512 | SHA1 | NONE .
 */
public data class ConnectorAs2ConfigArgs(
    public val compression: Output<String>,
    public val encryptionAlgorithm: Output<String>,
    public val localProfileId: Output<String>,
    public val mdnResponse: Output<String>,
    public val mdnSigningAlgorithm: Output<String>? = null,
    public val messageSubject: Output<String>? = null,
    public val partnerProfileId: Output<String>,
    public val signingAlgorithm: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.transfer.inputs.ConnectorAs2ConfigArgs> {
    override fun toJava(): com.pulumi.aws.transfer.inputs.ConnectorAs2ConfigArgs =
        com.pulumi.aws.transfer.inputs.ConnectorAs2ConfigArgs.builder()
            .compression(compression.applyValue({ args0 -> args0 }))
            .encryptionAlgorithm(encryptionAlgorithm.applyValue({ args0 -> args0 }))
            .localProfileId(localProfileId.applyValue({ args0 -> args0 }))
            .mdnResponse(mdnResponse.applyValue({ args0 -> args0 }))
            .mdnSigningAlgorithm(mdnSigningAlgorithm?.applyValue({ args0 -> args0 }))
            .messageSubject(messageSubject?.applyValue({ args0 -> args0 }))
            .partnerProfileId(partnerProfileId.applyValue({ args0 -> args0 }))
            .signingAlgorithm(signingAlgorithm.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectorAs2ConfigArgs].
 */
@PulumiTagMarker
public class ConnectorAs2ConfigArgsBuilder internal constructor() {
    private var compression: Output<String>? = null

    private var encryptionAlgorithm: Output<String>? = null

    private var localProfileId: Output<String>? = null

    private var mdnResponse: Output<String>? = null

    private var mdnSigningAlgorithm: Output<String>? = null

    private var messageSubject: Output<String>? = null

    private var partnerProfileId: Output<String>? = null

    private var signingAlgorithm: Output<String>? = null

    /**
     * @param value Specifies weather AS2 file is compressed. The valud values are ZLIB and  DISABLED.
     */
    @JvmName("hlkxfuulfkirhheb")
    public suspend fun compression(`value`: Output<String>) {
        this.compression = value
    }

    /**
     * @param value The algorithm that is used to encrypt the file. The valid values are AES128_CBC | AES192_CBC | AES256_CBC | NONE.
     */
    @JvmName("tirwdrywmkkvkgwm")
    public suspend fun encryptionAlgorithm(`value`: Output<String>) {
        this.encryptionAlgorithm = value
    }

    /**
     * @param value The unique identifier for the AS2 local profile.
     */
    @JvmName("psamugsrhhslvrab")
    public suspend fun localProfileId(`value`: Output<String>) {
        this.localProfileId = value
    }

    /**
     * @param value Used for outbound requests to determine if a partner response for transfers is synchronous or asynchronous. The valid values are SYNC and NONE.
     */
    @JvmName("ftmdqoqgkeureflq")
    public suspend fun mdnResponse(`value`: Output<String>) {
        this.mdnResponse = value
    }

    /**
     * @param value The signing algorithm for the Mdn response. The valid values are SHA256 | SHA384 | SHA512 | SHA1 | NONE | DEFAULT.
     */
    @JvmName("qspmwfgidigapfqb")
    public suspend fun mdnSigningAlgorithm(`value`: Output<String>) {
        this.mdnSigningAlgorithm = value
    }

    /**
     * @param value Used as the subject HTTP header attribute in AS2 messages that are being sent with the connector.
     */
    @JvmName("xaalmdcjwpluiwjc")
    public suspend fun messageSubject(`value`: Output<String>) {
        this.messageSubject = value
    }

    /**
     * @param value The unique identifier for the AS2 partner profile.
     */
    @JvmName("harfccjjnqljbcgq")
    public suspend fun partnerProfileId(`value`: Output<String>) {
        this.partnerProfileId = value
    }

    /**
     * @param value The algorithm that is used to sign AS2 messages sent with the connector. The valid values are SHA256 | SHA384 | SHA512 | SHA1 | NONE .
     */
    @JvmName("uioxeoflwgxyvkgo")
    public suspend fun signingAlgorithm(`value`: Output<String>) {
        this.signingAlgorithm = value
    }

    /**
     * @param value Specifies weather AS2 file is compressed. The valud values are ZLIB and  DISABLED.
     */
    @JvmName("uouwybcveoysyhdd")
    public suspend fun compression(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.compression = mapped
    }

    /**
     * @param value The algorithm that is used to encrypt the file. The valid values are AES128_CBC | AES192_CBC | AES256_CBC | NONE.
     */
    @JvmName("dtlrwxdbodvpcikk")
    public suspend fun encryptionAlgorithm(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.encryptionAlgorithm = mapped
    }

    /**
     * @param value The unique identifier for the AS2 local profile.
     */
    @JvmName("nsicvmjvmdyapjvf")
    public suspend fun localProfileId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.localProfileId = mapped
    }

    /**
     * @param value Used for outbound requests to determine if a partner response for transfers is synchronous or asynchronous. The valid values are SYNC and NONE.
     */
    @JvmName("yfhhjkwyxvdcnlas")
    public suspend fun mdnResponse(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mdnResponse = mapped
    }

    /**
     * @param value The signing algorithm for the Mdn response. The valid values are SHA256 | SHA384 | SHA512 | SHA1 | NONE | DEFAULT.
     */
    @JvmName("vhsydsudcusewifj")
    public suspend fun mdnSigningAlgorithm(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mdnSigningAlgorithm = mapped
    }

    /**
     * @param value Used as the subject HTTP header attribute in AS2 messages that are being sent with the connector.
     */
    @JvmName("rjejlwramgothxdf")
    public suspend fun messageSubject(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.messageSubject = mapped
    }

    /**
     * @param value The unique identifier for the AS2 partner profile.
     */
    @JvmName("esmupknijxdadmuk")
    public suspend fun partnerProfileId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.partnerProfileId = mapped
    }

    /**
     * @param value The algorithm that is used to sign AS2 messages sent with the connector. The valid values are SHA256 | SHA384 | SHA512 | SHA1 | NONE .
     */
    @JvmName("kvonpdusvlcpamxi")
    public suspend fun signingAlgorithm(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.signingAlgorithm = mapped
    }

    internal fun build(): ConnectorAs2ConfigArgs = ConnectorAs2ConfigArgs(
        compression = compression ?: throw PulumiNullFieldException("compression"),
        encryptionAlgorithm = encryptionAlgorithm ?: throw PulumiNullFieldException("encryptionAlgorithm"),
        localProfileId = localProfileId ?: throw PulumiNullFieldException("localProfileId"),
        mdnResponse = mdnResponse ?: throw PulumiNullFieldException("mdnResponse"),
        mdnSigningAlgorithm = mdnSigningAlgorithm,
        messageSubject = messageSubject,
        partnerProfileId = partnerProfileId ?: throw PulumiNullFieldException("partnerProfileId"),
        signingAlgorithm = signingAlgorithm ?: throw PulumiNullFieldException("signingAlgorithm"),
    )
}
