@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.transfer.kotlin.inputs

import com.pulumi.aws.transfer.inputs.ConnectorSftpConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property trustedHostKeys A list of public portion of the host key, or keys, that are used to authenticate the user to the external server to which you are connecting.(https://docs.aws.amazon.com/transfer/latest/userguide/API_SftpConnectorConfig.html)
 * @property userSecretId The identifier for the secret (in AWS Secrets Manager) that contains the SFTP user's private key, password, or both. The identifier can be either the Amazon Resource Name (ARN) or the name of the secret.
 */
public data class ConnectorSftpConfigArgs(
    public val trustedHostKeys: Output<List<String>>? = null,
    public val userSecretId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.transfer.inputs.ConnectorSftpConfigArgs> {
    override fun toJava(): com.pulumi.aws.transfer.inputs.ConnectorSftpConfigArgs =
        com.pulumi.aws.transfer.inputs.ConnectorSftpConfigArgs.builder()
            .trustedHostKeys(trustedHostKeys?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .userSecretId(userSecretId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectorSftpConfigArgs].
 */
@PulumiTagMarker
public class ConnectorSftpConfigArgsBuilder internal constructor() {
    private var trustedHostKeys: Output<List<String>>? = null

    private var userSecretId: Output<String>? = null

    /**
     * @param value A list of public portion of the host key, or keys, that are used to authenticate the user to the external server to which you are connecting.(https://docs.aws.amazon.com/transfer/latest/userguide/API_SftpConnectorConfig.html)
     */
    @JvmName("twbpxcpgebackrlr")
    public suspend fun trustedHostKeys(`value`: Output<List<String>>) {
        this.trustedHostKeys = value
    }

    @JvmName("qycnhxwivdfxevsj")
    public suspend fun trustedHostKeys(vararg values: Output<String>) {
        this.trustedHostKeys = Output.all(values.asList())
    }

    /**
     * @param values A list of public portion of the host key, or keys, that are used to authenticate the user to the external server to which you are connecting.(https://docs.aws.amazon.com/transfer/latest/userguide/API_SftpConnectorConfig.html)
     */
    @JvmName("dsaapttiakgwvbha")
    public suspend fun trustedHostKeys(values: List<Output<String>>) {
        this.trustedHostKeys = Output.all(values)
    }

    /**
     * @param value The identifier for the secret (in AWS Secrets Manager) that contains the SFTP user's private key, password, or both. The identifier can be either the Amazon Resource Name (ARN) or the name of the secret.
     */
    @JvmName("aixjaewbniwlitoj")
    public suspend fun userSecretId(`value`: Output<String>) {
        this.userSecretId = value
    }

    /**
     * @param value A list of public portion of the host key, or keys, that are used to authenticate the user to the external server to which you are connecting.(https://docs.aws.amazon.com/transfer/latest/userguide/API_SftpConnectorConfig.html)
     */
    @JvmName("pobngwhwovdcyteb")
    public suspend fun trustedHostKeys(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trustedHostKeys = mapped
    }

    /**
     * @param values A list of public portion of the host key, or keys, that are used to authenticate the user to the external server to which you are connecting.(https://docs.aws.amazon.com/transfer/latest/userguide/API_SftpConnectorConfig.html)
     */
    @JvmName("wyhfqesxqsuyompd")
    public suspend fun trustedHostKeys(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.trustedHostKeys = mapped
    }

    /**
     * @param value The identifier for the secret (in AWS Secrets Manager) that contains the SFTP user's private key, password, or both. The identifier can be either the Amazon Resource Name (ARN) or the name of the secret.
     */
    @JvmName("qkficgvwbnrftgys")
    public suspend fun userSecretId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userSecretId = mapped
    }

    internal fun build(): ConnectorSftpConfigArgs = ConnectorSftpConfigArgs(
        trustedHostKeys = trustedHostKeys,
        userSecretId = userSecretId,
    )
}
