@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.transfer.kotlin.inputs

import com.pulumi.aws.transfer.inputs.GetConnectorPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getConnector.
 * @property id Unique identifier for connector
 */
public data class GetConnectorPlainArgs(
    public val id: String,
) : ConvertibleToJava<com.pulumi.aws.transfer.inputs.GetConnectorPlainArgs> {
    override fun toJava(): com.pulumi.aws.transfer.inputs.GetConnectorPlainArgs =
        com.pulumi.aws.transfer.inputs.GetConnectorPlainArgs.builder()
            .id(id.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetConnectorPlainArgs].
 */
@PulumiTagMarker
public class GetConnectorPlainArgsBuilder internal constructor() {
    private var id: String? = null

    /**
     * @param value Unique identifier for connector
     */
    @JvmName("woqwltmfbxynsnyv")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.id = mapped
    }

    internal fun build(): GetConnectorPlainArgs = GetConnectorPlainArgs(
        id = id ?: throw PulumiNullFieldException("id"),
    )
}
