@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.transfer.kotlin.inputs

import com.pulumi.aws.transfer.inputs.GetServerPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getServer.
 * @property serverId ID for an SFTP server.
 */
public data class GetServerPlainArgs(
    public val serverId: String,
) : ConvertibleToJava<com.pulumi.aws.transfer.inputs.GetServerPlainArgs> {
    override fun toJava(): com.pulumi.aws.transfer.inputs.GetServerPlainArgs =
        com.pulumi.aws.transfer.inputs.GetServerPlainArgs.builder()
            .serverId(serverId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetServerPlainArgs].
 */
@PulumiTagMarker
public class GetServerPlainArgsBuilder internal constructor() {
    private var serverId: String? = null

    /**
     * @param value ID for an SFTP server.
     */
    @JvmName("lkfeqovjnkiagncp")
    public suspend fun serverId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serverId = mapped
    }

    internal fun build(): GetServerPlainArgs = GetServerPlainArgs(
        serverId = serverId ?: throw PulumiNullFieldException("serverId"),
    )
}
