@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.transfer.kotlin.inputs

import com.pulumi.aws.transfer.inputs.ServerS3StorageOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property directoryListingOptimization Specifies whether or not performance for your Amazon S3 directories is optimized. Valid values are `DISABLED`, `ENABLED`.
 * By default, home directory mappings have a `TYPE` of `DIRECTORY`. If you enable this option, you would then need to explicitly set the `HomeDirectoryMapEntry` Type to `FILE` if you want a mapping to have a file target. See [Using logical directories to simplify your Transfer Family directory structures](https://docs.aws.amazon.com/transfer/latest/userguide/logical-dir-mappings.html) for details.
 */
public data class ServerS3StorageOptionsArgs(
    public val directoryListingOptimization: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.transfer.inputs.ServerS3StorageOptionsArgs> {
    override fun toJava(): com.pulumi.aws.transfer.inputs.ServerS3StorageOptionsArgs =
        com.pulumi.aws.transfer.inputs.ServerS3StorageOptionsArgs.builder()
            .directoryListingOptimization(directoryListingOptimization?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServerS3StorageOptionsArgs].
 */
@PulumiTagMarker
public class ServerS3StorageOptionsArgsBuilder internal constructor() {
    private var directoryListingOptimization: Output<String>? = null

    /**
     * @param value Specifies whether or not performance for your Amazon S3 directories is optimized. Valid values are `DISABLED`, `ENABLED`.
     * By default, home directory mappings have a `TYPE` of `DIRECTORY`. If you enable this option, you would then need to explicitly set the `HomeDirectoryMapEntry` Type to `FILE` if you want a mapping to have a file target. See [Using logical directories to simplify your Transfer Family directory structures](https://docs.aws.amazon.com/transfer/latest/userguide/logical-dir-mappings.html) for details.
     */
    @JvmName("ucebqbtixnulhnom")
    public suspend fun directoryListingOptimization(`value`: Output<String>) {
        this.directoryListingOptimization = value
    }

    /**
     * @param value Specifies whether or not performance for your Amazon S3 directories is optimized. Valid values are `DISABLED`, `ENABLED`.
     * By default, home directory mappings have a `TYPE` of `DIRECTORY`. If you enable this option, you would then need to explicitly set the `HomeDirectoryMapEntry` Type to `FILE` if you want a mapping to have a file target. See [Using logical directories to simplify your Transfer Family directory structures](https://docs.aws.amazon.com/transfer/latest/userguide/logical-dir-mappings.html) for details.
     */
    @JvmName("klnknsomrypsmrks")
    public suspend fun directoryListingOptimization(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.directoryListingOptimization = mapped
    }

    internal fun build(): ServerS3StorageOptionsArgs = ServerS3StorageOptionsArgs(
        directoryListingOptimization = directoryListingOptimization,
    )
}
