@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.transfer.kotlin.inputs

import com.pulumi.aws.transfer.inputs.ServerWorkflowDetailsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property onPartialUpload A trigger that starts a workflow if a file is only partially uploaded. See Workflow Detail below. See `on_partial_upload` Block below for details.
 * @property onUpload A trigger that starts a workflow: the workflow begins to execute after a file is uploaded. See `on_upload` Block below for details.
 */
public data class ServerWorkflowDetailsArgs(
    public val onPartialUpload: Output<ServerWorkflowDetailsOnPartialUploadArgs>? = null,
    public val onUpload: Output<ServerWorkflowDetailsOnUploadArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.transfer.inputs.ServerWorkflowDetailsArgs> {
    override fun toJava(): com.pulumi.aws.transfer.inputs.ServerWorkflowDetailsArgs =
        com.pulumi.aws.transfer.inputs.ServerWorkflowDetailsArgs.builder()
            .onPartialUpload(onPartialUpload?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .onUpload(onUpload?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ServerWorkflowDetailsArgs].
 */
@PulumiTagMarker
public class ServerWorkflowDetailsArgsBuilder internal constructor() {
    private var onPartialUpload: Output<ServerWorkflowDetailsOnPartialUploadArgs>? = null

    private var onUpload: Output<ServerWorkflowDetailsOnUploadArgs>? = null

    /**
     * @param value A trigger that starts a workflow if a file is only partially uploaded. See Workflow Detail below. See `on_partial_upload` Block below for details.
     */
    @JvmName("aiacksgrkvpcckoh")
    public suspend fun onPartialUpload(`value`: Output<ServerWorkflowDetailsOnPartialUploadArgs>) {
        this.onPartialUpload = value
    }

    /**
     * @param value A trigger that starts a workflow: the workflow begins to execute after a file is uploaded. See `on_upload` Block below for details.
     */
    @JvmName("fbgyfflkrfjsnbsn")
    public suspend fun onUpload(`value`: Output<ServerWorkflowDetailsOnUploadArgs>) {
        this.onUpload = value
    }

    /**
     * @param value A trigger that starts a workflow if a file is only partially uploaded. See Workflow Detail below. See `on_partial_upload` Block below for details.
     */
    @JvmName("optlhemkirilhskk")
    public suspend fun onPartialUpload(`value`: ServerWorkflowDetailsOnPartialUploadArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onPartialUpload = mapped
    }

    /**
     * @param argument A trigger that starts a workflow if a file is only partially uploaded. See Workflow Detail below. See `on_partial_upload` Block below for details.
     */
    @JvmName("btyjjnoskgasskqy")
    public suspend fun onPartialUpload(argument: suspend ServerWorkflowDetailsOnPartialUploadArgsBuilder.() -> Unit) {
        val toBeMapped = ServerWorkflowDetailsOnPartialUploadArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.onPartialUpload = mapped
    }

    /**
     * @param value A trigger that starts a workflow: the workflow begins to execute after a file is uploaded. See `on_upload` Block below for details.
     */
    @JvmName("wwsfbmbsrubodnhh")
    public suspend fun onUpload(`value`: ServerWorkflowDetailsOnUploadArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onUpload = mapped
    }

    /**
     * @param argument A trigger that starts a workflow: the workflow begins to execute after a file is uploaded. See `on_upload` Block below for details.
     */
    @JvmName("qmvkauhfcmuojghr")
    public suspend fun onUpload(argument: suspend ServerWorkflowDetailsOnUploadArgsBuilder.() -> Unit) {
        val toBeMapped = ServerWorkflowDetailsOnUploadArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.onUpload = mapped
    }

    internal fun build(): ServerWorkflowDetailsArgs = ServerWorkflowDetailsArgs(
        onPartialUpload = onPartialUpload,
        onUpload = onUpload,
    )
}
