@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.transfer.kotlin.inputs

import com.pulumi.aws.transfer.inputs.WorkflowOnExceptionStepCopyStepDetailsDestinationFileLocationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property efsFileLocation Specifies the details for the EFS file being copied.
 * @property s3FileLocation Specifies the details for the S3 file being copied.
 */
public data class WorkflowOnExceptionStepCopyStepDetailsDestinationFileLocationArgs(
    public val efsFileLocation: Output<WorkflowOnExceptionStepCopyStepDetailsDestinationFileLocationEfsFileLocationArgs>? =
        null,
    public val s3FileLocation: Output<WorkflowOnExceptionStepCopyStepDetailsDestinationFileLocationS3FileLocationArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.transfer.inputs.WorkflowOnExceptionStepCopyStepDetailsDestinationFileLocationArgs> {
    override fun toJava(): com.pulumi.aws.transfer.inputs.WorkflowOnExceptionStepCopyStepDetailsDestinationFileLocationArgs =
        com.pulumi.aws.transfer.inputs.WorkflowOnExceptionStepCopyStepDetailsDestinationFileLocationArgs.builder()
            .efsFileLocation(efsFileLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .s3FileLocation(
                s3FileLocation?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [WorkflowOnExceptionStepCopyStepDetailsDestinationFileLocationArgs].
 */
@PulumiTagMarker
public class WorkflowOnExceptionStepCopyStepDetailsDestinationFileLocationArgsBuilder internal constructor() {
    private var efsFileLocation:
        Output<WorkflowOnExceptionStepCopyStepDetailsDestinationFileLocationEfsFileLocationArgs>? =
        null

    private var s3FileLocation:
        Output<WorkflowOnExceptionStepCopyStepDetailsDestinationFileLocationS3FileLocationArgs>? =
        null

    /**
     * @param value Specifies the details for the EFS file being copied.
     */
    @JvmName("mbqcooksymptinis")
    public suspend fun efsFileLocation(`value`: Output<WorkflowOnExceptionStepCopyStepDetailsDestinationFileLocationEfsFileLocationArgs>) {
        this.efsFileLocation = value
    }

    /**
     * @param value Specifies the details for the S3 file being copied.
     */
    @JvmName("xagsnjcypjpykmth")
    public suspend fun s3FileLocation(`value`: Output<WorkflowOnExceptionStepCopyStepDetailsDestinationFileLocationS3FileLocationArgs>) {
        this.s3FileLocation = value
    }

    /**
     * @param value Specifies the details for the EFS file being copied.
     */
    @JvmName("flgamrdlcaxjadsj")
    public suspend fun efsFileLocation(`value`: WorkflowOnExceptionStepCopyStepDetailsDestinationFileLocationEfsFileLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.efsFileLocation = mapped
    }

    /**
     * @param argument Specifies the details for the EFS file being copied.
     */
    @JvmName("wmtwlgflfyclhyfl")
    public suspend fun efsFileLocation(argument: suspend WorkflowOnExceptionStepCopyStepDetailsDestinationFileLocationEfsFileLocationArgsBuilder.() -> Unit) {
        val toBeMapped =
            WorkflowOnExceptionStepCopyStepDetailsDestinationFileLocationEfsFileLocationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.efsFileLocation = mapped
    }

    /**
     * @param value Specifies the details for the S3 file being copied.
     */
    @JvmName("ipsrcbqnkqwoqwol")
    public suspend fun s3FileLocation(`value`: WorkflowOnExceptionStepCopyStepDetailsDestinationFileLocationS3FileLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3FileLocation = mapped
    }

    /**
     * @param argument Specifies the details for the S3 file being copied.
     */
    @JvmName("sudqscmtwemcvsou")
    public suspend fun s3FileLocation(argument: suspend WorkflowOnExceptionStepCopyStepDetailsDestinationFileLocationS3FileLocationArgsBuilder.() -> Unit) {
        val toBeMapped =
            WorkflowOnExceptionStepCopyStepDetailsDestinationFileLocationS3FileLocationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.s3FileLocation = mapped
    }

    internal fun build(): WorkflowOnExceptionStepCopyStepDetailsDestinationFileLocationArgs =
        WorkflowOnExceptionStepCopyStepDetailsDestinationFileLocationArgs(
            efsFileLocation = efsFileLocation,
            s3FileLocation = s3FileLocation,
        )
}
