@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.transfer.kotlin.inputs

import com.pulumi.aws.transfer.inputs.WorkflowOnExceptionStepCustomStepDetailsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name The name of the step, used as an identifier.
 * @property sourceFileLocation Specifies which file to use as input to the workflow step: either the output from the previous step, or the originally uploaded file for the workflow. Enter ${previous.file} to use the previous file as the input. In this case, this workflow step uses the output file from the previous workflow step as input. This is the default value. Enter ${original.file} to use the originally-uploaded file location as input for this step.
 * @property target The ARN for the lambda function that is being called.
 * @property timeoutSeconds Timeout, in seconds, for the step.
 */
public data class WorkflowOnExceptionStepCustomStepDetailsArgs(
    public val name: Output<String>? = null,
    public val sourceFileLocation: Output<String>? = null,
    public val target: Output<String>? = null,
    public val timeoutSeconds: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.transfer.inputs.WorkflowOnExceptionStepCustomStepDetailsArgs> {
    override fun toJava(): com.pulumi.aws.transfer.inputs.WorkflowOnExceptionStepCustomStepDetailsArgs = com.pulumi.aws.transfer.inputs.WorkflowOnExceptionStepCustomStepDetailsArgs.builder()
        .name(name?.applyValue({ args0 -> args0 }))
        .sourceFileLocation(sourceFileLocation?.applyValue({ args0 -> args0 }))
        .target(target?.applyValue({ args0 -> args0 }))
        .timeoutSeconds(timeoutSeconds?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkflowOnExceptionStepCustomStepDetailsArgs].
 */
@PulumiTagMarker
public class WorkflowOnExceptionStepCustomStepDetailsArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var sourceFileLocation: Output<String>? = null

    private var target: Output<String>? = null

    private var timeoutSeconds: Output<Int>? = null

    /**
     * @param value The name of the step, used as an identifier.
     */
    @JvmName("buqkkgqlxtktidja")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Specifies which file to use as input to the workflow step: either the output from the previous step, or the originally uploaded file for the workflow. Enter ${previous.file} to use the previous file as the input. In this case, this workflow step uses the output file from the previous workflow step as input. This is the default value. Enter ${original.file} to use the originally-uploaded file location as input for this step.
     */
    @JvmName("kelyhxwbwexhsqvf")
    public suspend fun sourceFileLocation(`value`: Output<String>) {
        this.sourceFileLocation = value
    }

    /**
     * @param value The ARN for the lambda function that is being called.
     */
    @JvmName("epqvdqyqdtiwwfst")
    public suspend fun target(`value`: Output<String>) {
        this.target = value
    }

    /**
     * @param value Timeout, in seconds, for the step.
     */
    @JvmName("rwggonwjvipdinuk")
    public suspend fun timeoutSeconds(`value`: Output<Int>) {
        this.timeoutSeconds = value
    }

    /**
     * @param value The name of the step, used as an identifier.
     */
    @JvmName("ppqpbjuvdxkpgfho")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Specifies which file to use as input to the workflow step: either the output from the previous step, or the originally uploaded file for the workflow. Enter ${previous.file} to use the previous file as the input. In this case, this workflow step uses the output file from the previous workflow step as input. This is the default value. Enter ${original.file} to use the originally-uploaded file location as input for this step.
     */
    @JvmName("atdqfrchrhstayvg")
    public suspend fun sourceFileLocation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceFileLocation = mapped
    }

    /**
     * @param value The ARN for the lambda function that is being called.
     */
    @JvmName("mcpqmafeutpfqsrl")
    public suspend fun target(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.target = mapped
    }

    /**
     * @param value Timeout, in seconds, for the step.
     */
    @JvmName("yhedvablesllgimx")
    public suspend fun timeoutSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeoutSeconds = mapped
    }

    internal fun build(): WorkflowOnExceptionStepCustomStepDetailsArgs =
        WorkflowOnExceptionStepCustomStepDetailsArgs(
            name = name,
            sourceFileLocation = sourceFileLocation,
            target = target,
            timeoutSeconds = timeoutSeconds,
        )
}
