@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.transfer.kotlin.inputs

import com.pulumi.aws.transfer.inputs.WorkflowOnExceptionStepDecryptStepDetailsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property destinationFileLocation Specifies the location for the file being copied. Use ${Transfer:username} in this field to parametrize the destination prefix by username.
 * @property name The name of the step, used as an identifier.
 * @property overwriteExisting A flag that indicates whether or not to overwrite an existing file of the same name. The default is `FALSE`. Valid values are `TRUE` and `FALSE`.
 * @property sourceFileLocation Specifies which file to use as input to the workflow step: either the output from the previous step, or the originally uploaded file for the workflow. Enter ${previous.file} to use the previous file as the input. In this case, this workflow step uses the output file from the previous workflow step as input. This is the default value. Enter ${original.file} to use the originally-uploaded file location as input for this step.
 * @property type The type of encryption used. Currently, this value must be `"PGP"`.
 */
public data class WorkflowOnExceptionStepDecryptStepDetailsArgs(
    public val destinationFileLocation: Output<WorkflowOnExceptionStepDecryptStepDetailsDestinationFileLocationArgs>? = null,
    public val name: Output<String>? = null,
    public val overwriteExisting: Output<String>? = null,
    public val sourceFileLocation: Output<String>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.transfer.inputs.WorkflowOnExceptionStepDecryptStepDetailsArgs> {
    override fun toJava(): com.pulumi.aws.transfer.inputs.WorkflowOnExceptionStepDecryptStepDetailsArgs =
        com.pulumi.aws.transfer.inputs.WorkflowOnExceptionStepDecryptStepDetailsArgs.builder()
            .destinationFileLocation(
                destinationFileLocation?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .overwriteExisting(overwriteExisting?.applyValue({ args0 -> args0 }))
            .sourceFileLocation(sourceFileLocation?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkflowOnExceptionStepDecryptStepDetailsArgs].
 */
@PulumiTagMarker
public class WorkflowOnExceptionStepDecryptStepDetailsArgsBuilder internal constructor() {
    private var destinationFileLocation:
        Output<WorkflowOnExceptionStepDecryptStepDetailsDestinationFileLocationArgs>? = null

    private var name: Output<String>? = null

    private var overwriteExisting: Output<String>? = null

    private var sourceFileLocation: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value Specifies the location for the file being copied. Use ${Transfer:username} in this field to parametrize the destination prefix by username.
     */
    @JvmName("gefivncpirjicjeg")
    public suspend fun destinationFileLocation(`value`: Output<WorkflowOnExceptionStepDecryptStepDetailsDestinationFileLocationArgs>) {
        this.destinationFileLocation = value
    }

    /**
     * @param value The name of the step, used as an identifier.
     */
    @JvmName("emkufbniaoxpkiag")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A flag that indicates whether or not to overwrite an existing file of the same name. The default is `FALSE`. Valid values are `TRUE` and `FALSE`.
     */
    @JvmName("vdvraduwoxydvuci")
    public suspend fun overwriteExisting(`value`: Output<String>) {
        this.overwriteExisting = value
    }

    /**
     * @param value Specifies which file to use as input to the workflow step: either the output from the previous step, or the originally uploaded file for the workflow. Enter ${previous.file} to use the previous file as the input. In this case, this workflow step uses the output file from the previous workflow step as input. This is the default value. Enter ${original.file} to use the originally-uploaded file location as input for this step.
     */
    @JvmName("wfhbwsluddnltglj")
    public suspend fun sourceFileLocation(`value`: Output<String>) {
        this.sourceFileLocation = value
    }

    /**
     * @param value The type of encryption used. Currently, this value must be `"PGP"`.
     */
    @JvmName("bqkffygdvsigmatw")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Specifies the location for the file being copied. Use ${Transfer:username} in this field to parametrize the destination prefix by username.
     */
    @JvmName("aaqqqfynqsrdledl")
    public suspend fun destinationFileLocation(`value`: WorkflowOnExceptionStepDecryptStepDetailsDestinationFileLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationFileLocation = mapped
    }

    /**
     * @param argument Specifies the location for the file being copied. Use ${Transfer:username} in this field to parametrize the destination prefix by username.
     */
    @JvmName("odehslsfglogaatv")
    public suspend fun destinationFileLocation(argument: suspend WorkflowOnExceptionStepDecryptStepDetailsDestinationFileLocationArgsBuilder.() -> Unit) {
        val toBeMapped =
            WorkflowOnExceptionStepDecryptStepDetailsDestinationFileLocationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.destinationFileLocation = mapped
    }

    /**
     * @param value The name of the step, used as an identifier.
     */
    @JvmName("ramnfqdvvsxjwuyy")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A flag that indicates whether or not to overwrite an existing file of the same name. The default is `FALSE`. Valid values are `TRUE` and `FALSE`.
     */
    @JvmName("bdkxxikuntwmftwf")
    public suspend fun overwriteExisting(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.overwriteExisting = mapped
    }

    /**
     * @param value Specifies which file to use as input to the workflow step: either the output from the previous step, or the originally uploaded file for the workflow. Enter ${previous.file} to use the previous file as the input. In this case, this workflow step uses the output file from the previous workflow step as input. This is the default value. Enter ${original.file} to use the originally-uploaded file location as input for this step.
     */
    @JvmName("nhmybmuvvmucoeak")
    public suspend fun sourceFileLocation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceFileLocation = mapped
    }

    /**
     * @param value The type of encryption used. Currently, this value must be `"PGP"`.
     */
    @JvmName("easunqpcgdrrnjbq")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): WorkflowOnExceptionStepDecryptStepDetailsArgs =
        WorkflowOnExceptionStepDecryptStepDetailsArgs(
            destinationFileLocation = destinationFileLocation,
            name = name,
            overwriteExisting = overwriteExisting,
            sourceFileLocation = sourceFileLocation,
            type = type ?: throw PulumiNullFieldException("type"),
        )
}
